// শীতলকার কমিউনিটি অ্যাপ - টাইপ ডেফিনিশন

export interface Doctor {
  id: string;
  name: string;
  specialization: string;
  hospital: string;
  area: string;
  phone: string;
  imageUrl?: string;
  status: 'published' | 'pending' | 'draft';
  createdAt: string;
  updatedAt: string;
}

export interface BloodDonor {
  id: string;
  name: string;
  bloodGroup: string;
  phone: string;
  address: string;
  hospital: string;
  lastDonation?: string;
  status: 'published' | 'pending' | 'draft';
  deviceId?: string;
  createdAt: string;
}

export interface Ambulance {
  id: string;
  name: string;
  driverName: string;
  phone: string;
  area: string;
  vehicleNumber: string;
  status: 'published' | 'pending' | 'draft';
  createdAt: string;
}

export interface FireService {
  id: string;
  name: string;
  address: string;
  phone: string;
  status: 'published' | 'pending' | 'draft';
}

export interface Police {
  id: string;
  name: string;
  designation: string;
  station: string;
  area: string;
  phone: string;
  status: 'published' | 'pending' | 'draft';
}

export interface Lawyer {
  id: string;
  name: string;
  specialization: string;
  address: string;
  phone: string;
  status: 'published' | 'pending' | 'draft';
}

export interface Imam {
  id: string;
  name: string;
  mosque: string;
  address: string;
  phone: string;
  status: 'published' | 'pending' | 'draft';
}

export interface Member {
  id: string;
  name: string;
  designation: string;
  union: string;
  area: string;
  phone: string;
  imageUrl?: string;
  status: 'published' | 'pending' | 'draft';
}

export interface Player {
  id: string;
  name: string;
  position: string;
  playType: string;
  phone: string;
  image?: string;
  status: 'published' | 'pending' | 'draft';
}

export interface ClubUser {
  id: string;
  name: string;
  email: string;
  phone: string;
  dob: string;
  address: string;
  imagePath?: string;
  position: string;
  status: 'approved' | 'pending' | 'rejected';
  createdAt: string;
}

export interface SliderImage {
  id: string;
  imageUrl: string;
  title?: string;
  link?: string;
  order: number;
  status: 'active' | 'inactive';
}

export interface Donation {
  id: string;
  name: string;
  phone: string;
  amount: number;
  method: string;
  transactionId?: string;
  status: 'completed' | 'pending' | 'failed';
  createdAt: string;
}

export interface AppSettings {
  breakingNews: string;
  sliderSpeed: number;
  contactEmail: string;
  contactPhone: string;
  whatsapp: string;
  facebook: string;
  location: string;
}

export interface DashboardStats {
  totalDoctors: number;
  totalBloodDonors: number;
  totalMembers: number;
  totalPlayers: number;
  pendingRequests: number;
  totalDonations: number;
  todayVisitors: number;
  activeUsers: number;
}

export type CategoryType = 
  | 'doctors' 
  | 'blood-donors' 
  | 'ambulance' 
  | 'fire-service' 
  | 'police' 
  | 'lawyers' 
  | 'imams' 
  | 'members' 
  | 'players' 
  | 'club-users'
  | 'slider'
  | 'donations'
  | 'settings';
