import { useState } from "react";
import { AdminLayout } from "@/components/admin/AdminLayout";
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Input } from "@/components/ui/input";
import { Label } from "@/components/ui/label";
import { Textarea } from "@/components/ui/textarea";
import { Switch } from "@/components/ui/switch";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { toast } from "sonner";
import {
  Settings,
  Globe,
  MessageSquare,
  Bell,
  Palette,
  Shield,
  Save,
  Phone,
  Mail,
  MapPin,
  Facebook,
  MessageCircle,
} from "lucide-react";

export default function SettingsPage() {
  const [settings, setSettings] = useState({
    breakingNews: "🔔 শীতলকার কমিউনিটি অ্যাপে স্বাগতম! আমাদের সাথে থাকুন।",
    sliderSpeed: 3000,
    contactEmail: "admin@shitolkar.top",
    contactPhone: "০১৭১২৩৪৫৬৭৮",
    whatsapp: "০১৭১২৩৪৫৬৭৮",
    facebook: "https://facebook.com/shitolkar",
    location: "শীতলকার, বরিশাল, বাংলাদেশ",
    enableNotifications: true,
    enableAutoApproval: false,
    maintenanceMode: false,
  });

  const handleSave = () => {
    toast.success("সেটিংস সফলভাবে সংরক্ষণ করা হয়েছে");
  };

  return (
    <AdminLayout title="সেটিংস" description="অ্যাপ্লিকেশন সেটিংস পরিচালনা করুন">
      <Tabs defaultValue="general" className="space-y-6">
        <TabsList className="bg-muted/50 p-1">
          <TabsTrigger value="general" className="gap-2">
            <Settings className="h-4 w-4" />
            সাধারণ
          </TabsTrigger>
          <TabsTrigger value="contact" className="gap-2">
            <MessageSquare className="h-4 w-4" />
            যোগাযোগ
          </TabsTrigger>
          <TabsTrigger value="notifications" className="gap-2">
            <Bell className="h-4 w-4" />
            নোটিফিকেশন
          </TabsTrigger>
          <TabsTrigger value="security" className="gap-2">
            <Shield className="h-4 w-4" />
            নিরাপত্তা
          </TabsTrigger>
        </TabsList>

        {/* General Settings */}
        <TabsContent value="general">
          <Card className="glass-card">
            <CardHeader>
              <CardTitle className="flex items-center gap-2">
                <Globe className="h-5 w-5 text-primary" />
                সাধারণ সেটিংস
              </CardTitle>
            </CardHeader>
            <CardContent className="space-y-6">
              <div className="grid gap-2">
                <Label htmlFor="breakingNews">ব্রেকিং নিউজ</Label>
                <Textarea
                  id="breakingNews"
                  value={settings.breakingNews}
                  onChange={(e) =>
                    setSettings({ ...settings, breakingNews: e.target.value })
                  }
                  placeholder="ব্রেকিং নিউজ টেক্সট লিখুন..."
                  className="min-h-[100px]"
                />
                <p className="text-sm text-muted-foreground">
                  এই টেক্সট অ্যাপের হোম পেজে মার্কি হিসেবে দেখানো হবে
                </p>
              </div>

              <div className="grid gap-2">
                <Label htmlFor="sliderSpeed">স্লাইডার স্পিড (মিলিসেকেন্ড)</Label>
                <Input
                  id="sliderSpeed"
                  type="number"
                  value={settings.sliderSpeed}
                  onChange={(e) =>
                    setSettings({ ...settings, sliderSpeed: Number(e.target.value) })
                  }
                />
                <p className="text-sm text-muted-foreground">
                  স্লাইডার কত মিলিসেকেন্ড পর পর পরিবর্তন হবে (১০০০ = ১ সেকেন্ড)
                </p>
              </div>

              <div className="flex items-center justify-between p-4 rounded-lg bg-muted/50">
                <div>
                  <Label htmlFor="maintenance">মেইনটেন্যান্স মোড</Label>
                  <p className="text-sm text-muted-foreground">
                    সক্রিয় করলে ব্যবহারকারীরা অ্যাপ ব্যবহার করতে পারবে না
                  </p>
                </div>
                <Switch
                  id="maintenance"
                  checked={settings.maintenanceMode}
                  onCheckedChange={(checked) =>
                    setSettings({ ...settings, maintenanceMode: checked })
                  }
                />
              </div>
            </CardContent>
          </Card>
        </TabsContent>

        {/* Contact Settings */}
        <TabsContent value="contact">
          <Card className="glass-card">
            <CardHeader>
              <CardTitle className="flex items-center gap-2">
                <MessageSquare className="h-5 w-5 text-primary" />
                যোগাযোগ তথ্য
              </CardTitle>
            </CardHeader>
            <CardContent className="space-y-6">
              <div className="grid gap-4 md:grid-cols-2">
                <div className="grid gap-2">
                  <Label htmlFor="contactEmail" className="flex items-center gap-2">
                    <Mail className="h-4 w-4" />
                    ইমেইল
                  </Label>
                  <Input
                    id="contactEmail"
                    type="email"
                    value={settings.contactEmail}
                    onChange={(e) =>
                      setSettings({ ...settings, contactEmail: e.target.value })
                    }
                  />
                </div>

                <div className="grid gap-2">
                  <Label htmlFor="contactPhone" className="flex items-center gap-2">
                    <Phone className="h-4 w-4" />
                    ফোন নম্বর
                  </Label>
                  <Input
                    id="contactPhone"
                    value={settings.contactPhone}
                    onChange={(e) =>
                      setSettings({ ...settings, contactPhone: e.target.value })
                    }
                  />
                </div>

                <div className="grid gap-2">
                  <Label htmlFor="whatsapp" className="flex items-center gap-2">
                    <MessageCircle className="h-4 w-4" />
                    হোয়াটসঅ্যাপ
                  </Label>
                  <Input
                    id="whatsapp"
                    value={settings.whatsapp}
                    onChange={(e) =>
                      setSettings({ ...settings, whatsapp: e.target.value })
                    }
                  />
                </div>

                <div className="grid gap-2">
                  <Label htmlFor="facebook" className="flex items-center gap-2">
                    <Facebook className="h-4 w-4" />
                    ফেসবুক পেজ
                  </Label>
                  <Input
                    id="facebook"
                    value={settings.facebook}
                    onChange={(e) =>
                      setSettings({ ...settings, facebook: e.target.value })
                    }
                  />
                </div>
              </div>

              <div className="grid gap-2">
                <Label htmlFor="location" className="flex items-center gap-2">
                  <MapPin className="h-4 w-4" />
                  ঠিকানা
                </Label>
                <Input
                  id="location"
                  value={settings.location}
                  onChange={(e) =>
                    setSettings({ ...settings, location: e.target.value })
                  }
                />
              </div>
            </CardContent>
          </Card>
        </TabsContent>

        {/* Notification Settings */}
        <TabsContent value="notifications">
          <Card className="glass-card">
            <CardHeader>
              <CardTitle className="flex items-center gap-2">
                <Bell className="h-5 w-5 text-primary" />
                নোটিফিকেশন সেটিংস
              </CardTitle>
            </CardHeader>
            <CardContent className="space-y-6">
              <div className="flex items-center justify-between p-4 rounded-lg bg-muted/50">
                <div>
                  <Label>পুশ নোটিফিকেশন</Label>
                  <p className="text-sm text-muted-foreground">
                    নতুন অনুরোধ আসলে নোটিফিকেশন পাঠান
                  </p>
                </div>
                <Switch
                  checked={settings.enableNotifications}
                  onCheckedChange={(checked) =>
                    setSettings({ ...settings, enableNotifications: checked })
                  }
                />
              </div>

              <div className="flex items-center justify-between p-4 rounded-lg bg-muted/50">
                <div>
                  <Label>অটো অনুমোদন</Label>
                  <p className="text-sm text-muted-foreground">
                    নতুন অনুরোধ স্বয়ংক্রিয়ভাবে অনুমোদন করুন
                  </p>
                </div>
                <Switch
                  checked={settings.enableAutoApproval}
                  onCheckedChange={(checked) =>
                    setSettings({ ...settings, enableAutoApproval: checked })
                  }
                />
              </div>
            </CardContent>
          </Card>
        </TabsContent>

        {/* Security Settings */}
        <TabsContent value="security">
          <Card className="glass-card">
            <CardHeader>
              <CardTitle className="flex items-center gap-2">
                <Shield className="h-5 w-5 text-primary" />
                নিরাপত্তা সেটিংস
              </CardTitle>
            </CardHeader>
            <CardContent className="space-y-6">
              <div className="grid gap-4 md:grid-cols-2">
                <div className="grid gap-2">
                  <Label htmlFor="currentPassword">বর্তমান পাসওয়ার্ড</Label>
                  <Input id="currentPassword" type="password" />
                </div>

                <div className="grid gap-2">
                  <Label htmlFor="newPassword">নতুন পাসওয়ার্ড</Label>
                  <Input id="newPassword" type="password" />
                </div>
              </div>

              <div className="grid gap-2">
                <Label htmlFor="confirmPassword">নতুন পাসওয়ার্ড নিশ্চিত করুন</Label>
                <Input id="confirmPassword" type="password" />
              </div>

              <Button variant="outline" className="w-full md:w-auto">
                পাসওয়ার্ড পরিবর্তন করুন
              </Button>
            </CardContent>
          </Card>
        </TabsContent>
      </Tabs>

      {/* Save Button */}
      <div className="flex justify-end mt-6">
        <Button onClick={handleSave} className="btn-gradient-primary gap-2">
          <Save className="h-4 w-4" />
          সেটিংস সংরক্ষণ করুন
        </Button>
      </div>
    </AdminLayout>
  );
}
