import { ReactNode } from "react";
import { AdminSidebar } from "./AdminSidebar";
import { AdminHeader } from "./AdminHeader";
import { cn } from "@/lib/utils";

interface AdminLayoutProps {
  children: ReactNode;
  title: string;
  description?: string;
  actions?: ReactNode;
}

export function AdminLayout({ children, title, description, actions }: AdminLayoutProps) {
  return (
    <div className="min-h-screen bg-background">
      <AdminSidebar />
      
      <div className="lg:pl-64 flex flex-col min-h-screen">
        <AdminHeader title={title} description={description} actions={actions} />
        
        <main className="flex-1 p-4 md:p-6 lg:p-8 animate-fade-in">
          {children}
        </main>

        <footer className="border-t border-border py-4 px-6 text-center text-sm text-muted-foreground">
          <p>© ২০২৫ শীতলকার কমিউনিটি সার্ভিস। সর্বস্বত্ব সংরক্ষিত।</p>
        </footer>
      </div>
    </div>
  );
}
