import { Toaster } from "@/components/ui/toaster";
import { Toaster as Sonner } from "@/components/ui/sonner";
import { TooltipProvider } from "@/components/ui/tooltip";
import { QueryClient, QueryClientProvider } from "@tanstack/react-query";
import { BrowserRouter, Routes, Route } from "react-router-dom";
import Dashboard from "./pages/Dashboard";
import DoctorsPage from "./pages/DoctorsPage";
import BloodDonorsPage from "./pages/BloodDonorsPage";
import AmbulancePage from "./pages/AmbulancePage";
import FireServicePage from "./pages/FireServicePage";
import PolicePage from "./pages/PolicePage";
import LawyersPage from "./pages/LawyersPage";
import ImamsPage from "./pages/ImamsPage";
import MembersPage from "./pages/MembersPage";
import PlayersPage from "./pages/PlayersPage";
import ClubUsersPage from "./pages/ClubUsersPage";
import SliderPage from "./pages/SliderPage";
import DonationsPage from "./pages/DonationsPage";
import SettingsPage from "./pages/SettingsPage";
import NotFound from "./pages/NotFound";

const queryClient = new QueryClient();

const App = () => (
  <QueryClientProvider client={queryClient}>
    <TooltipProvider>
      <Toaster />
      <Sonner />
      <BrowserRouter>
        <Routes>
          <Route path="/" element={<Dashboard />} />
          <Route path="/doctors" element={<DoctorsPage />} />
          <Route path="/blood-donors" element={<BloodDonorsPage />} />
          <Route path="/ambulance" element={<AmbulancePage />} />
          <Route path="/fire-service" element={<FireServicePage />} />
          <Route path="/police" element={<PolicePage />} />
          <Route path="/lawyers" element={<LawyersPage />} />
          <Route path="/imams" element={<ImamsPage />} />
          <Route path="/members" element={<MembersPage />} />
          <Route path="/players" element={<PlayersPage />} />
          <Route path="/club-users" element={<ClubUsersPage />} />
          <Route path="/slider" element={<SliderPage />} />
          <Route path="/donations" element={<DonationsPage />} />
          <Route path="/settings" element={<SettingsPage />} />
          <Route path="*" element={<NotFound />} />
        </Routes>
      </BrowserRouter>
    </TooltipProvider>
  </QueryClientProvider>
);

export default App;
