<?php
header('Content-Type: application/json');
include 'includes/config.php';

$type = $_GET['type'] ?? ''; // 'club' or 'device'

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if ($type === 'club') {
        $cat = $CATEGORIES['club_registration'];
        $data = readJSON($cat['file']);
        
        $new_item = ['id' => time()];
        foreach ($cat['fields'] as $field) {
            if ($field === 'status') {
                $new_item[$field] = 'pending';
            } else {
                $new_item[$field] = $_POST[$field] ?? '';
            }
        }
        
        $data[] = $new_item;
        writeJSON($cat['file'], $data);
        echo json_encode(['status' => 'success', 'message' => 'Registration submitted for approval']);
        
    } elseif ($type === 'device') {
        $cat = $CATEGORIES['devices'];
        $data = readJSON($cat['file']);
        
        $deviceId = $_POST['deviceId'] ?? '';
        $exists = false;
        foreach ($data as $device) {
            if ($device['deviceId'] === $deviceId) {
                $exists = true;
                break;
            }
        }
        
        if (!$exists) {
            $new_item = [
                'id' => time(),
                'deviceId' => $deviceId,
                'deviceName' => $_POST['deviceName'] ?? 'Unknown',
                'status' => 'active'
            ];
            $data[] = $new_item;
            writeJSON($cat['file'], $data);
        }
        echo json_encode(['status' => 'success', 'message' => 'Device registered']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Invalid registration type']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
}
?>
