<?php
include 'includes/config.php';
checkAuth();

$cat_key = $_GET['cat'] ?? '';
if (!isset($CATEGORIES[$cat_key])) {
    header('Location: index.php');
    exit;
}

$category = $CATEGORIES[$cat_key];
$data = readJSON($category['file']);
$message = "";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['add'])) {
        $new_item = ['id' => time()];
        foreach ($category['fields'] as $field) {
            $new_item[$field] = $_POST[$field] ?? '';
        }
        $data[] = $new_item;
        writeJSON($category['file'], $data);
        $message = "সফলভাবে যোগ করা হয়েছে!";
    } elseif (isset($_POST['delete'])) {
        $id = $_POST['id'];
        $data = array_filter($data, function($item) use ($id) { return $item['id'] != $id; });
        writeJSON($category['file'], $data);
        $message = "মুছে ফেলা হয়েছে!";
    }
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <title><?php echo $category['title']; ?> ব্যবস্থাপনা</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root { --sidebar-width: 260px; }
        body { background: #f8f9fa; }
        .sidebar { width: var(--sidebar-width); height: 100vh; position: fixed; background: #2c3e50; color: white; overflow-y: auto; }
        .sidebar a { color: #bdc3c7; text-decoration: none; padding: 12px 20px; display: block; }
        .sidebar a:hover, .sidebar a.active { background: #34495e; color: white; }
        .main-content { margin-left: var(--sidebar-width); padding: 30px; }
        .card { border: none; box-shadow: 0 4px 6px rgba(0,0,0,0.05); }
    </style>
</head>
<body>
    <div class="sidebar">
        <div class="p-3 text-center"><h4>অ্যাডমিন</h4></div>
        <a href="index.php"><i class="fas fa-tachometer-alt me-2"></i> ড্যাশবোর্ড</a>
        <hr class="mx-3">
        <?php foreach($CATEGORIES as $key => $cat): ?>
            <a href="manage.php?cat=<?php echo $key; ?>" class="<?php echo $cat_key == $key ? 'active' : ''; ?>">
                <i class="fas fa-list me-2"></i> <?php echo $cat['title']; ?>
            </a>
        <?php endforeach; ?>
        <hr class="mx-3">
        <a href="logout.php" class="text-danger"><i class="fas fa-sign-out-alt me-2"></i> লগআউট</a>
    </div>

    <div class="main-content">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2><?php echo $category['title']; ?> ব্যবস্থাপনা</h2>
            <a href="index.php" class="btn btn-secondary btn-sm"><i class="fas fa-arrow-left"></i> ফিরে যান</a>
        </div>

        <?php if($message): ?>
            <div class="alert alert-success alert-dismissible fade show">
                <?php echo $message; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <div class="card p-4 mb-4">
            <h5 class="mb-3">নতুন তথ্য যোগ করুন</h5>
            <form method="POST" class="row g-3">
                <?php foreach($category['fields'] as $field): ?>
                    <div class="col-md-4">
                        <label class="form-label"><?php echo ucfirst(str_replace('_', ' ', $field)); ?></label>
                        <?php if($field == 'status'): ?>
                            <select name="status" class="form-select">
                                <?php if($cat_key == 'club_registration'): ?>
                                    <option value="pending">Pending</option>
                                    <option value="approved">Approved</option>
                                    <option value="rejected">Rejected</option>
                                <?php elseif($cat_key == 'devices'): ?>
                                    <option value="active">Active</option>
                                    <option value="blocked">Blocked</option>
                                <?php else: ?>
                                    <option value="published">Published</option>
                                    <option value="draft">Draft</option>
                                <?php endif; ?>
                            </select>
                        <?php elseif($field == 'blood_group'): ?>
                            <select name="blood_group" class="form-select">
                                <option value="A+">A+</option><option value="A-">A-</option>
                                <option value="B+">B+</option><option value="B-">B-</option>
                                <option value="O+">O+</option><option value="O-">O-</option>
                                <option value="AB+">AB+</option><option value="AB-">AB-</option>
                            </select>
                        <?php else: ?>
                            <input type="text" name="<?php echo $field; ?>" class="form-control" placeholder="<?php echo $field; ?>" required>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
                <div class="col-12">
                    <button type="submit" name="add" class="btn btn-primary"><i class="fas fa-plus"></i> যোগ করুন</button>
                </div>
            </form>
        </div>

        <div class="card p-4">
            <h5 class="mb-3">বর্তমান তালিকা</h5>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                        <tr>
                            <?php foreach($category['fields'] as $field): ?>
                                <th><?php echo ucfirst(str_replace('_', ' ', $field)); ?></th>
                            <?php endforeach; ?>
                            <th>অ্যাকশন</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($data as $item): ?>
                            <tr>
                                <?php foreach($category['fields'] as $field): ?>
                                    <td>
                                        <?php if($field == 'status'): ?>
                                            <?php 
                                                $badge_class = 'bg-secondary';
                                                if(in_array($item[$field], ['published', 'approved', 'active'])) $badge_class = 'bg-success';
                                                if(in_array($item[$field], ['draft', 'pending'])) $badge_class = 'bg-warning';
                                                if(in_array($item[$field], ['rejected', 'blocked'])) $badge_class = 'bg-danger';
                                            ?>
                                            <span class="badge <?php echo $badge_class; ?>">
                                                <?php echo $item[$field]; ?>
                                            </span>
                                        <?php else: ?>
                                            <?php echo $item[$field]; ?>
                                        <?php endif; ?>
                                    </td>
                                <?php endforeach; ?>
                                <td>
                                    <form method="POST" style="display:inline;" onsubmit="return confirm('আপনি কি নিশ্চিত?')">
                                        <input type="hidden" name="id" value="<?php echo $item['id']; ?>">
                                        <button type="submit" name="delete" class="btn btn-danger btn-sm"><i class="fas fa-trash"></i></button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        <?php if(empty($data)): ?>
                            <tr><td colspan="<?php echo count($category['fields']) + 1; ?>" class="text-center">কোনো তথ্য পাওয়া যায়নি</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
