<?php
include 'includes/config.php';
checkAuth();
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ড্যাশবোর্ড - অ্যাডমিন প্যানেল</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root { --sidebar-width: 260px; }
        body { background: #f8f9fa; }
        .sidebar { width: var(--sidebar-width); height: 100vh; position: fixed; background: #2c3e50; color: white; overflow-y: auto; }
        .sidebar-header { padding: 20px; background: #1a252f; text-align: center; }
        .sidebar a { color: #bdc3c7; text-decoration: none; padding: 12px 20px; display: block; transition: 0.3s; }
        .sidebar a:hover, .sidebar a.active { background: #34495e; color: white; border-left: 4px solid #3498db; }
        .main-content { margin-left: var(--sidebar-width); padding: 30px; }
        .stat-card { border: none; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.05); transition: 0.3s; }
        .stat-card:hover { transform: translateY(-5px); }
    </style>
</head>
<body>
    <div class="sidebar">
        <div class="sidebar-header">
            <h4>অ্যাডমিন প্যানেল</h4>
        </div>
        <a href="index.php" class="active"><i class="fas fa-tachometer-alt me-2"></i> ড্যাশবোর্ড</a>
        <hr class="mx-3">
        <?php foreach($CATEGORIES as $key => $cat): ?>
            <a href="manage.php?cat=<?php echo $key; ?>"><i class="fas fa-list me-2"></i> <?php echo $cat['title']; ?></a>
        <?php endforeach; ?>
        <hr class="mx-3">
        <a href="logout.php" class="text-danger"><i class="fas fa-sign-out-alt me-2"></i> লগআউট</a>
    </div>

    <div class="main-content">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2>স্বাগতম, অ্যাডমিন!</h2>
            <span class="badge bg-primary p-2"><?php echo date('d M, Y'); ?></span>
        </div>

        <div class="row">
            <?php foreach($CATEGORIES as $key => $cat): 
                $data = readJSON($cat['file']);
            ?>
            <div class="col-md-3 mb-4">
                <div class="card stat-card p-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted"><?php echo $cat['title']; ?></h6>
                            <h3><?php echo count($data); ?></h3>
                        </div>
                        <div class="icon-box text-primary">
                            <i class="fas fa-database fa-2x"></i>
                        </div>
                    </div>
                    <a href="manage.php?cat=<?php echo $key; ?>" class="btn btn-sm btn-outline-primary mt-3">ম্যানেজ করুন</a>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</body>
</html>
