<?php
session_start();

// Admin Credentials
define('ADMIN_USER', 'admin');
define('ADMIN_PASS', 'admin123');

// Database Path
define('DATA_DIR', __DIR__ . '/../data/');

// All Categories from Source Code
$CATEGORIES = [
    'slider' => ['title' => 'স্লাইডার ইমেজ', 'file' => 'slider.json', 'fields' => ['imageUrl', 'status']],
    'doctors' => ['title' => 'ডাক্তার', 'file' => 'doctors.json', 'fields' => ['name', 'specialization', 'hospital', 'area', 'phone', 'status']],
    'fire_service' => ['title' => 'ফায়ার সার্ভিস', 'file' => 'fire_service.json', 'fields' => ['name', 'address', 'phone', 'status']],
    'imam' => ['title' => 'ইমাম সাহেব', 'file' => 'imam.json', 'fields' => ['name', 'mosque', 'area', 'phone', 'status']],
    'kazi' => ['title' => 'কাজী অফিস', 'file' => 'kazi.json', 'fields' => ['name', 'address', 'phone', 'status']],
    'lawyer' => ['title' => 'আইনজীবী', 'file' => 'lawyer.json', 'fields' => ['name', 'court', 'area', 'phone', 'status']],
    'member_chairman' => ['title' => 'মেম্বার-চেয়ারম্যান', 'file' => 'member_chairman.json', 'fields' => ['name', 'position', 'union', 'phone', 'status']],
    'ambulance' => ['title' => 'অ্যাম্বুলেন্স', 'file' => 'ambulance.json', 'fields' => ['name', 'area', 'phone', 'status']],
    'blood_donors' => ['title' => 'রক্তদাতা', 'file' => 'blood_donors.json', 'fields' => ['name', 'blood_group', 'area', 'phone', 'deviceId', 'status']],
    'club_registration' => ['title' => 'ক্লাব রেজিস্ট্রেশন', 'file' => 'club_registration.json', 'fields' => ['name', 'phone', 'address', 'club_name', 'deviceId', 'status']],
    'donations' => ['title' => 'ডোনেশন হিস্ট্রি', 'file' => 'donations.json', 'fields' => ['name', 'amount', 'transaction_id', 'date', 'status']],
    'players' => ['title' => 'খেলোয়াড়', 'file' => 'players.json', 'fields' => ['name', 'sport', 'team', 'phone', 'image', 'status']],
    'police' => ['title' => 'পুলিশ', 'file' => 'police.json', 'fields' => ['name', 'station', 'area', 'phone', 'status']],
    'education' => ['title' => 'শিক্ষা প্রতিষ্ঠান', 'file' => 'education.json', 'fields' => ['name', 'type', 'area', 'phone', 'status']],
    'social_service' => ['title' => 'সমাজসেবা', 'file' => 'social_service.json', 'fields' => ['name', 'service_type', 'area', 'phone', 'status']],
    'policy' => ['title' => 'নীতিমালা (Policy)', 'file' => 'policy.json', 'fields' => ['title', 'content', 'status']],
    'contact_info' => ['title' => 'যোগাযোগ তথ্য', 'file' => 'contact_info.json', 'fields' => ['call', 'whatsapp', 'email']],
    'user_data' => ['title' => 'ইউজার ডেটা (Collected)', 'file' => 'user_data.json', 'fields' => ['device_id', 'model', 'version', 'last_seen']],
    'devices' => ['title' => 'ডিভাইস কন্ট্রোল (Ban)', 'file' => 'devices.json', 'fields' => ['deviceId', 'deviceName', 'status']]
];

function readJSON($filename) {
    $path = DATA_DIR . $filename;
    if (!file_exists($path)) {
        file_put_contents($path, json_encode([]));
        return [];
    }
    return json_decode(file_get_contents($path), true) ?: [];
}

function writeJSON($filename, $data) {
    $path = DATA_DIR . $filename;
    return file_put_contents($path, json_encode(array_values($data), JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

function checkAuth() {
    if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
        header('Location: login.php');
        exit;
    }
}
?>
