<?php
header('Content-Type: application/json');
include 'includes/config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $data = readJSON('user_data.json');
    $device_id = $_POST['device_id'] ?? '';
    
    $found = false;
    foreach ($data as &$user) {
        if ($user['device_id'] === $device_id) {
            $user['last_seen'] = date('Y-m-d H:i:s');
            $user['model'] = $_POST['model'] ?? $user['model'];
            $found = true;
            break;
        }
    }
    
    if (!$found) {
        $data[] = [
            'id' => time(),
            'device_id' => $device_id,
            'model' => $_POST['model'] ?? 'Unknown',
            'version' => $_POST['version'] ?? 'Unknown',
            'last_seen' => date('Y-m-d H:i:s')
        ];
    }
    
    writeJSON('user_data.json', $data);
    echo json_encode(['status' => 'success']);
}
?>
