<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
include 'includes/config.php';

$category_key = $_GET['category'] ?? '';
$query = $_GET['query'] ?? '';
$deviceId = $_GET['deviceId'] ?? '';

// 1. Device Ban Check (Every API call checks this)
if (!empty($deviceId)) {
    $devices = readJSON('devices.json');
    foreach ($devices as $device) {
        if ($device['deviceId'] === $deviceId && $device['status'] === 'blocked') {
            http_response_code(403);
            echo json_encode(['status' => 'error', 'message' => 'Your device is blocked by admin']);
            exit;
        }
    }
}

// 2. Handle Specific API Endpoints from Source Code
if ($category_key === 'slider') {
    $data = readJSON('slider.json');
    $output = [];
    foreach ($data as $item) {
        if ($item['status'] === 'published') $output[] = $item;
    }
    echo json_encode($output);
    exit;
}

if ($category_key === 'fire_service') {
    $data = readJSON('fire_service.json');
    echo json_encode(['fire_services' => array_values($data)]);
    exit;
}

if ($category_key === 'contact_info') {
    $data = readJSON('contact_info.json');
    echo json_encode($data[0] ?? []);
    exit;
}

// 3. Generic Category Handler
if (isset($CATEGORIES[$category_key])) {
    $cat = $CATEGORIES[$category_key];
    $data = readJSON($cat['file']);
    
    // Filter by status
    if (in_array('status', $cat['fields'])) {
        $data = array_filter($data, function($item) use ($category_key) {
            if ($category_key === 'club_registration') return $item['status'] === 'approved';
            return $item['status'] === 'published';
        });
    }

    // Search query
    if (!empty($query)) {
        $data = array_filter($data, function($item) use ($query) {
            foreach ($item as $val) {
                if (stripos((string)$val, $query) !== false) return true;
            }
            return false;
        });
    }

    echo json_encode(array_values($data));
} else {
    echo json_encode(['error' => 'Invalid category']);
}
?>
