\
<?php
// Talashi JSON Backend (no database)
// Put this folder in your hosting (e.g., public_html/talashi_api/)

define('TALASHI_DATA_DIR', __DIR__ . '/data');

// Change these in production
define('TALASHI_ADMIN_SALT', 'CHANGE_THIS_SALT_2026');

if (!is_dir(TALASHI_DATA_DIR)) {
    mkdir(TALASHI_DATA_DIR, 0755, true);
}

function talashi_json_read($file, $default) {
    $path = TALASHI_DATA_DIR . '/' . $file;
    if (!file_exists($path)) return $default;
    $raw = file_get_contents($path);
    if ($raw === false || trim($raw) === '') return $default;
    $data = json_decode($raw, true);
    if (json_last_error() !== JSON_ERROR_NONE) return $default;
    return $data;
}

function talashi_json_write($file, $data) {
    $path = TALASHI_DATA_DIR . '/' . $file;
    $tmp  = $path . '.tmp';
    $json = json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    if ($json === false) return false;

    $fp = fopen($tmp, 'wb');
    if (!$fp) return false;
    if (!flock($fp, LOCK_EX)) { fclose($fp); return false; }
    fwrite($fp, $json);
    fflush($fp);
    flock($fp, LOCK_UN);
    fclose($fp);

    return rename($tmp, $path);
}

function talashi_send_json($arr, $code=200) {
    http_response_code($code);
    header('Content-Type: application/json; charset=utf-8');
    header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
    header('Pragma: no-cache');
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
    header('Access-Control-Allow-Headers: Content-Type');
    echo json_encode($arr, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit;
}

function talashi_read_body_json() {
    $raw = file_get_contents('php://input');
    $data = json_decode($raw, true);
    if (!is_array($data)) return [];
    return $data;
}

function talashi_now() {
    return date('Y-m-d H:i:s');
}

function talashi_id($prefix='id') {
    return $prefix . '_' . substr(bin2hex(random_bytes(8)), 0, 16);
}

function talashi_find_index_by_id($arr, $id) {
    for ($i=0; $i<count($arr); $i++) {
        if (isset($arr[$i]['id']) && $arr[$i]['id'] === $id) return $i;
    }
    return -1;
}

function talashi_admin_hash($password) {
    return hash('sha256', TALASHI_ADMIN_SALT . '|' . $password);
}
