\
<?php
require_once __DIR__ . '/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') talashi_send_json(['ok'=>true]);

$body = talashi_read_body_json();

$provider_id = trim($body['provider_id'] ?? '');
$method = trim($body['method'] ?? '');
$amount = intval($body['amount'] ?? 0);
$fields = $body['fields'] ?? null;

if ($provider_id === '' || $method === '' || $amount <= 0 || !is_array($fields)) {
    talashi_send_json(['ok'=>false,'error'=>'Invalid payload'], 400);
}

$providers = talashi_json_read('providers.json', []);
$idx = talashi_find_index_by_id($providers, $provider_id);
if ($idx < 0) talashi_send_json(['ok'=>false,'error'=>'Provider not found'], 404);

// store payment
$payments = talashi_json_read('payments.json', []);
$payment_id = talashi_id('pay');
$payments[] = [
    'id' => $payment_id,
    'provider_id' => $provider_id,
    'method' => $method,
    'amount' => $amount,
    'fields' => $fields,
    'status' => 'pending',
    'created_at' => talashi_now(),
];

if (!talashi_json_write('payments.json', $payments)) {
    talashi_send_json(['ok'=>false,'error'=>'Failed to write payments'], 500);
}

// mark provider paid=false until admin approves payment
talashi_send_json(['ok'=>true,'payment_id'=>$payment_id,'status'=>'pending']);
