\
<?php
require_once __DIR__ . '/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') talashi_send_json(['ok'=>true]);

$body = talashi_read_body_json();
$device_id = trim($body['device_id'] ?? '');
$data = $body['data'] ?? null;

if ($device_id === '' || !is_array($data)) {
    talashi_send_json(['ok'=>false,'error'=>'Invalid payload'], 400);
}

$providers = talashi_json_read('providers.json', []);

$provider_id = talashi_id('prov');

$providers[] = [
    'id' => $provider_id,
    'data' => $data,
    'device_id' => $device_id,
    'status' => 'pending',
    'paid' => false,
    'created_at' => talashi_now(),
    'updated_at' => talashi_now(),
];

if (!talashi_json_write('providers.json', $providers)) {
    talashi_send_json(['ok'=>false,'error'=>'Failed to write providers'], 500);
}

talashi_send_json(['ok'=>true,'provider_id'=>$provider_id,'status'=>'pending']);
