\
<?php
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/_layout_top.php';

$settings = talashi_json_read('settings.json', [
  'provider_registration'=>['mode'=>'free','fee'=>0],
  'provider_form_fields'=>[],
  'payment_methods'=>[],
  'payment_fields'=>[]
]);

$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $mode = ($_POST['mode'] ?? 'free') === 'paid' ? 'paid' : 'free';
  $fee  = intval($_POST['fee'] ?? 0);
  $settings['provider_registration'] = ['mode'=>$mode,'fee'=>$fee];

  // JSON textarea inputs
  $pf = trim($_POST['provider_form_fields'] ?? '[]');
  $pm = trim($_POST['payment_methods'] ?? '[]');
  $payf = trim($_POST['payment_fields'] ?? '[]');

  $pfArr = json_decode($pf, true);
  $pmArr = json_decode($pm, true);
  $payfArr = json_decode($payf, true);

  if (json_last_error() === JSON_ERROR_NONE) {
    if (is_array($pfArr)) $settings['provider_form_fields'] = $pfArr;
    if (is_array($pmArr)) $settings['payment_methods'] = $pmArr;
    if (is_array($payfArr)) $settings['payment_fields'] = $payfArr;
    talashi_json_write('settings.json', $settings);
    $msg = 'Saved!';
  } else {
    $msg = 'Invalid JSON in one of the fields.';
  }
  // reload
  $settings = talashi_json_read('settings.json', $settings);
}

function pretty($x){ return json_encode($x, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT); }
?>
<h3 class="mb-3">Settings</h3>

<?php if($msg): ?>
  <div class="alert alert-info"><?php echo htmlspecialchars($msg); ?></div>
<?php endif; ?>

<form method="post">
  <div class="card shadow-sm mb-3">
    <div class="card-body">
      <div class="row g-2 align-items-end">
        <div class="col-md-4">
          <label class="form-label">Provider Registration Mode</label>
          <select class="form-select" name="mode">
            <option value="free" <?php echo (($settings['provider_registration']['mode']??'free')==='free')?'selected':''; ?>>free</option>
            <option value="paid" <?php echo (($settings['provider_registration']['mode']??'free')==='paid')?'selected':''; ?>>paid</option>
          </select>
        </div>
        <div class="col-md-4">
          <label class="form-label">Fee (BDT)</label>
          <input class="form-control" type="number" name="fee" value="<?php echo intval($settings['provider_registration']['fee'] ?? 0); ?>">
        </div>
      </div>
      <div class="text-muted small mt-2">Tip: Paid হলে payment form Android অ্যাপে অটো দেখাবে।</div>
    </div>
  </div>

  <div class="card shadow-sm mb-3">
    <div class="card-body">
      <label class="form-label">Provider Form Fields (JSON array)</label>
      <textarea class="form-control" name="provider_form_fields" rows="10"><?php echo htmlspecialchars(pretty($settings['provider_form_fields'] ?? [])); ?></textarea>
      <div class="small text-muted mt-2">Each item: {"key","label","type","required", "options"(for select)}</div>
    </div>
  </div>

  <div class="card shadow-sm mb-3">
    <div class="card-body">
      <label class="form-label">Payment Methods (JSON array)</label>
      <textarea class="form-control" name="payment_methods" rows="8"><?php echo htmlspecialchars(pretty($settings['payment_methods'] ?? [])); ?></textarea>
      <div class="small text-muted mt-2">Each item: {"method","number","instructions"}</div>
    </div>
  </div>

  <div class="card shadow-sm mb-3">
    <div class="card-body">
      <label class="form-label">Payment Fields (JSON array)</label>
      <textarea class="form-control" name="payment_fields" rows="8"><?php echo htmlspecialchars(pretty($settings['payment_fields'] ?? [])); ?></textarea>
      <div class="small text-muted mt-2">Each item: {"key","label","required"}</div>
    </div>
  </div>

  <button class="btn btn-primary">Save Settings</button>
</form>

<hr class="my-4">
<div class="alert alert-warning">
  <b>Security:</b> Please change <code>TALASHI_ADMIN_SALT</code> in <code>config.php</code> and update admin password after upload.
</div>

<?php require_once __DIR__ . '/_layout_bottom.php'; ?>
