\
<?php
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/_layout_top.php';

$services = talashi_json_read('services.json', []);

// actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    if ($action === 'add') {
        $title = trim($_POST['title'] ?? '');
        if ($title !== '') {
            $services[] = [
                'id' => talashi_id('srv'),
                'title' => $title,
                'icon' => trim($_POST['icon'] ?? ''),
                'status' => ($_POST['status'] ?? 'published') === 'published' ? 'published' : 'unpublished',
                'created_at' => date('Y-m-d')
            ];
            talashi_json_write('services.json', $services);
        }
    }
    if ($action === 'toggle') {
        $id = $_POST['id'] ?? '';
        $idx = talashi_find_index_by_id($services, $id);
        if ($idx >= 0) {
            $services[$idx]['status'] = ($services[$idx]['status'] ?? 'unpublished') === 'published' ? 'unpublished' : 'published';
            talashi_json_write('services.json', $services);
        }
    }
    if ($action === 'delete') {
        $id = $_POST['id'] ?? '';
        $idx = talashi_find_index_by_id($services, $id);
        if ($idx >= 0) {
            array_splice($services, $idx, 1);
            talashi_json_write('services.json', $services);
        }
    }
    header('Location: services.php');
    exit;
}
?>
<h3 class="mb-3">Services</h3>

<div class="card shadow-sm mb-3">
  <div class="card-body">
    <form method="post" class="row g-2 align-items-end">
      <input type="hidden" name="action" value="add">
      <div class="col-md-5">
        <label class="form-label">Title</label>
        <input class="form-control" name="title" placeholder="e.g., Electrician" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Icon filename (optional)</label>
        <input class="form-control" name="icon" placeholder="electric.png">
      </div>
      <div class="col-md-2">
        <label class="form-label">Status</label>
        <select class="form-select" name="status">
          <option value="published">published</option>
          <option value="unpublished">unpublished</option>
        </select>
      </div>
      <div class="col-md-1 d-grid">
        <button class="btn btn-primary">Add</button>
      </div>
    </form>
  </div>
</div>

<div class="card shadow-sm">
  <div class="card-body p-0">
    <table class="table table-hover mb-0">
      <thead class="table-light">
        <tr>
          <th>Title</th>
          <th>Status</th>
          <th>ID</th>
          <th class="text-end">Actions</th>
        </tr>
      </thead>
      <tbody>
      <?php foreach($services as $s): ?>
        <tr>
          <td><?php echo htmlspecialchars($s['title'] ?? ''); ?></td>
          <td><span class="badge <?php echo (($s['status']??'')==='published')?'bg-success':'bg-secondary'; ?>"><?php echo htmlspecialchars($s['status'] ?? ''); ?></span></td>
          <td class="text-muted small"><?php echo htmlspecialchars($s['id'] ?? ''); ?></td>
          <td class="text-end">
            <form method="post" class="d-inline">
              <input type="hidden" name="action" value="toggle">
              <input type="hidden" name="id" value="<?php echo htmlspecialchars($s['id'] ?? ''); ?>">
              <button class="btn btn-sm btn-outline-dark">Toggle</button>
            </form>
            <form method="post" class="d-inline" onsubmit="return confirm('Delete this service?');">
              <input type="hidden" name="action" value="delete">
              <input type="hidden" name="id" value="<?php echo htmlspecialchars($s['id'] ?? ''); ?>">
              <button class="btn btn-sm btn-outline-danger">Delete</button>
            </form>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require_once __DIR__ . '/_layout_bottom.php'; ?>
