\
<?php
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/_layout_top.php';

$providers = talashi_json_read('providers.json', []);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $action = $_POST['action'] ?? '';
  $id = $_POST['id'] ?? '';
  $idx = talashi_find_index_by_id($providers, $id);
  if ($idx >= 0) {
    if ($action === 'approve') $providers[$idx]['status'] = 'approved';
    if ($action === 'reject')  $providers[$idx]['status'] = 'rejected';
    if ($action === 'block')   $providers[$idx]['status'] = 'blocked';
    $providers[$idx]['updated_at'] = talashi_now();
    talashi_json_write('providers.json', $providers);
  }
  header('Location: providers.php');
  exit;
}
?>
<h3 class="mb-3">Providers</h3>

<div class="card shadow-sm">
  <div class="card-body p-0">
    <table class="table table-hover mb-0">
      <thead class="table-light">
        <tr>
          <th>Name/Phone</th>
          <th>Service/Area</th>
          <th>Status</th>
          <th>Paid</th>
          <th class="text-end">Actions</th>
        </tr>
      </thead>
      <tbody>
      <?php foreach($providers as $p): 
        $d = $p['data'] ?? [];
      ?>
        <tr>
          <td>
            <div class="fw-semibold"><?php echo htmlspecialchars($d['name'] ?? ''); ?></div>
            <div class="text-muted small"><?php echo htmlspecialchars($d['phone'] ?? ''); ?></div>
            <div class="text-muted small">ID: <?php echo htmlspecialchars($p['id'] ?? ''); ?></div>
          </td>
          <td>
            <div><?php echo htmlspecialchars($d['service'] ?? ''); ?></div>
            <div class="text-muted small"><?php echo htmlspecialchars($d['area'] ?? ''); ?></div>
          </td>
          <td>
            <span class="badge bg-<?php
              $st = $p['status'] ?? 'pending';
              echo ($st==='approved')?'success':(($st==='pending')?'warning':(($st==='rejected')?'secondary':'danger'));
            ?>"><?php echo htmlspecialchars($p['status'] ?? 'pending'); ?></span>
          </td>
          <td><?php echo !empty($p['paid']) ? 'Yes' : 'No'; ?></td>
          <td class="text-end">
            <form method="post" class="d-inline">
              <input type="hidden" name="id" value="<?php echo htmlspecialchars($p['id'] ?? ''); ?>">
              <input type="hidden" name="action" value="approve">
              <button class="btn btn-sm btn-outline-success">Approve</button>
            </form>
            <form method="post" class="d-inline">
              <input type="hidden" name="id" value="<?php echo htmlspecialchars($p['id'] ?? ''); ?>">
              <input type="hidden" name="action" value="reject">
              <button class="btn btn-sm btn-outline-secondary">Reject</button>
            </form>
            <form method="post" class="d-inline">
              <input type="hidden" name="id" value="<?php echo htmlspecialchars($p['id'] ?? ''); ?>">
              <input type="hidden" name="action" value="block">
              <button class="btn btn-sm btn-outline-danger">Block</button>
            </form>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require_once __DIR__ . '/_layout_bottom.php'; ?>
