\
<?php
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/_layout_top.php';

$payments = talashi_json_read('payments.json', []);
$providers = talashi_json_read('providers.json', []);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $action = $_POST['action'] ?? '';
  $id = $_POST['id'] ?? '';

  // update payment
  $pidx = talashi_find_index_by_id($payments, $id);
  if ($pidx >= 0) {
    if ($action === 'approve') $payments[$pidx]['status'] = 'approved';
    if ($action === 'reject')  $payments[$pidx]['status'] = 'rejected';
    talashi_json_write('payments.json', $payments);

    // if approved -> mark provider paid=true and optionally approved status
    if ($action === 'approve') {
      $provId = $payments[$pidx]['provider_id'] ?? '';
      $idx = talashi_find_index_by_id($providers, $provId);
      if ($idx >= 0) {
        $providers[$idx]['paid'] = true;
        if (($providers[$idx]['status'] ?? 'pending') === 'pending') {
          $providers[$idx]['status'] = 'approved';
        }
        $providers[$idx]['updated_at'] = talashi_now();
        talashi_json_write('providers.json', $providers);
      }
    }
  }
  header('Location: payments.php');
  exit;
}
?>
<h3 class="mb-3">Payments</h3>

<div class="card shadow-sm">
  <div class="card-body p-0">
    <table class="table table-hover mb-0">
      <thead class="table-light">
        <tr>
          <th>Provider ID</th>
          <th>Method</th>
          <th>Amount</th>
          <th>Fields</th>
          <th>Status</th>
          <th class="text-end">Actions</th>
        </tr>
      </thead>
      <tbody>
      <?php foreach($payments as $pay): ?>
        <tr>
          <td class="text-muted small"><?php echo htmlspecialchars($pay['provider_id'] ?? ''); ?></td>
          <td><?php echo htmlspecialchars($pay['method'] ?? ''); ?></td>
          <td><?php echo intval($pay['amount'] ?? 0); ?></td>
          <td class="small text-muted">
            <?php
              $fields = $pay['fields'] ?? [];
              foreach($fields as $k=>$v){
                echo '<div><b>'.htmlspecialchars($k).'</b>: '.htmlspecialchars((string)$v).'</div>';
              }
            ?>
          </td>
          <td>
            <span class="badge bg-<?php
              $st = $pay['status'] ?? 'pending';
              echo ($st==='approved')?'success':(($st==='pending')?'warning':(($st==='rejected')?'secondary':'secondary'));
            ?>"><?php echo htmlspecialchars($st); ?></span>
          </td>
          <td class="text-end">
            <form method="post" class="d-inline">
              <input type="hidden" name="id" value="<?php echo htmlspecialchars($pay['id'] ?? ''); ?>">
              <input type="hidden" name="action" value="approve">
              <button class="btn btn-sm btn-outline-success">Approve</button>
            </form>
            <form method="post" class="d-inline">
              <input type="hidden" name="id" value="<?php echo htmlspecialchars($pay['id'] ?? ''); ?>">
              <input type="hidden" name="action" value="reject">
              <button class="btn btn-sm btn-outline-secondary">Reject</button>
            </form>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require_once __DIR__ . '/_layout_bottom.php'; ?>
