\
<?php
require_once __DIR__ . '/_auth.php';

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $u = trim($_POST['username'] ?? '');
    $p = trim($_POST['password'] ?? '');
    if (admin_login($u, $p)) {
        header('Location: index.php');
        exit;
    } else {
        $error = 'Login failed';
    }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title>Talashi Admin Login</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container" style="max-width:460px;">
  <div class="card shadow-sm mt-5">
    <div class="card-body p-4">
      <h4 class="mb-1">Talashi Admin</h4>
      <div class="text-muted mb-3">Login to manage services & providers</div>

      <?php if($error): ?>
        <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
      <?php endif; ?>

      <form method="post">
        <div class="mb-3">
          <label class="form-label">Username</label>
          <input class="form-control" name="username" required value="admin"/>
        </div>
        <div class="mb-3">
          <label class="form-label">Password</label>
          <input class="form-control" type="password" name="password" required value="admin123"/>
        </div>
        <button class="btn btn-primary w-100">Login</button>
      </form>
      <div class="small text-muted mt-3">
        Default: <b>admin</b> / <b>admin123</b> (Change after upload)
      </div>
    </div>
  </div>
</div>
</body>
</html>
