\
<?php
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/_layout_top.php';

$services = talashi_json_read('services.json', []);
$providers = talashi_json_read('providers.json', []);
$payments = talashi_json_read('payments.json', []);

$published = 0; $unpublished = 0;
foreach ($services as $s) {
  if (($s['status'] ?? '') === 'published') $published++; else $unpublished++;
}
$pendingProv = 0; $approvedProv = 0;
foreach ($providers as $p) {
  if (($p['status'] ?? '') === 'pending') $pendingProv++;
  if (($p['status'] ?? '') === 'approved') $approvedProv++;
}
$pendingPay = 0; $approvedPay = 0;
foreach ($payments as $pay) {
  if (($pay['status'] ?? '') === 'pending') $pendingPay++;
  if (($pay['status'] ?? '') === 'approved') $approvedPay++;
}
?>
<h3 class="mb-3">Dashboard</h3>
<div class="row g-3">
  <div class="col-md-3">
    <div class="card shadow-sm">
      <div class="card-body">
        <div class="text-muted">Services Published</div>
        <div class="fs-3 fw-bold"><?php echo $published; ?></div>
      </div>
    </div>
  </div>
  <div class="col-md-3">
    <div class="card shadow-sm">
      <div class="card-body">
        <div class="text-muted">Services Unpublished</div>
        <div class="fs-3 fw-bold"><?php echo $unpublished; ?></div>
      </div>
    </div>
  </div>
  <div class="col-md-3">
    <div class="card shadow-sm">
      <div class="card-body">
        <div class="text-muted">Providers Pending</div>
        <div class="fs-3 fw-bold"><?php echo $pendingProv; ?></div>
      </div>
    </div>
  </div>
  <div class="col-md-3">
    <div class="card shadow-sm">
      <div class="card-body">
        <div class="text-muted">Providers Approved</div>
        <div class="fs-3 fw-bold"><?php echo $approvedProv; ?></div>
      </div>
    </div>
  </div>
</div>

<div class="row g-3 mt-1">
  <div class="col-md-3">
    <div class="card shadow-sm">
      <div class="card-body">
        <div class="text-muted">Payments Pending</div>
        <div class="fs-3 fw-bold"><?php echo $pendingPay; ?></div>
      </div>
    </div>
  </div>
  <div class="col-md-3">
    <div class="card shadow-sm">
      <div class="card-body">
        <div class="text-muted">Payments Approved</div>
        <div class="fs-3 fw-bold"><?php echo $approvedPay; ?></div>
      </div>
    </div>
  </div>
</div>

<hr class="my-4">
<div class="alert alert-info">
  Tip: Go to <b>Settings</b> to set Free/Paid registration, fee, form fields, payment methods & payment fields.
</div>

<?php require_once __DIR__ . '/_layout_bottom.php'; ?>
