<?php
// =============================================================
// Production-ready JSON Admin Panel (PHP)
// =============================================================
// ✅ JSON storage (no MySQL)
// ✅ AdminLTE design (CDN)
// ✅ CRUD + Approve/Publish/Delete/Edit
// ✅ Analytics dashboard (Chart.js)
// ✅ API endpoints for Android app

// If hosted inside a subfolder, set base URL.
// Example: https://systemtamim.top/php_app
$BASE_URL = "";

// First login credentials (change after login)
$DEFAULT_ADMIN_EMAIL = "admin@localhost";
$DEFAULT_ADMIN_PASSWORD = "admin123";

// Paths
$APP_ROOT = __DIR__;
$DATA_DIR = $APP_ROOT . "/data";
$UPLOAD_DIR = $APP_ROOT . "/uploads";

// Security
date_default_timezone_set("Asia/Dhaka");

// Create required folders if missing
@mkdir($DATA_DIR, 0775, true);
@mkdir($UPLOAD_DIR, 0775, true);

// Admin credential storage file (JSON)
if (!defined("ADMIN_FILE")) {
    define("ADMIN_FILE", $DATA_DIR . "/admin.json");
}


// JSON helper options
$JSON_FLAGS = JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT;

// App version
$APP_VERSION = "1.0.0";
