<?php
require_once __DIR__ . '/../common.php';

$category = trim($_GET['category'] ?? '');
$q = trim($_GET['q'] ?? '');

$list = api_read('urgent_numbers.json', []);
$out = [];

foreach($list as $it){
    if(($it['status'] ?? 'published') !== 'published') continue;
    if($category && strcasecmp((string)($it['category'] ?? ''), $category) !== 0) continue;

    if($q){
        $hay = strtolower(($it['name'] ?? '').' '.($it['area'] ?? '').' '.($it['phone'] ?? ''));
        if(strpos($hay, strtolower($q)) === false) continue;
    }
    $out[] = $it;
}

api_json(['status' => 'success', 'count' => count($out), 'data' => $out]);
