<?php
require_once __DIR__ . '/../common.php';
$slider = api_read('slider.json', ['slider_speed'=>3000,'breaking_news'=>'','images'=>[]]);

// Build output
$out = [
  'slider_speed' => (int)($slider['slider_speed'] ?? 3000),
  'breaking_news' => (string)($slider['breaking_news'] ?? ''),
  'images' => []
];

foreach(($slider['images'] ?? []) as $img){
    if(($img['status'] ?? 'published') !== 'published') continue;
    $out['images'][] = [
        'id' => $img['id'] ?? '',
        'imageUrl' => $img['imageUrl'] ?? '',
        'status' => $img['status'] ?? 'published'
    ];
}

api_json($out);
