<?php
require_once __DIR__ . '/../common.php';

// Accept JSON or form POST
$payload = [];
if (strpos($_SERVER['CONTENT_TYPE'] ?? '', 'application/json') !== false) {
    $payload = json_decode(file_get_contents('php://input'), true) ?: [];
} else {
    $payload = $_POST;
}

$name = trim($payload['name'] ?? '');
$method = trim($payload['method'] ?? 'bkash');
$amount = trim($payload['amount'] ?? '');
$trx = trim($payload['trxid'] ?? $payload['transaction_id'] ?? '');
$device_id = trim($payload['device_id'] ?? '');

if ($name === '' || $trx === '' || $amount === '') {
    api_json(['success'=>false,'message'=>'Missing required fields'], 400);
}

$tx = api_read('donation_transactions.json', []);

foreach($tx as $t){
    if (strcasecmp($t['trxid'] ?? '', $trx) === 0) {
        api_json(['success'=>false,'message'=>'This Transaction ID already submitted'], 409);
    }
}

$new = [
  'id' => uniqid('tx_', true),
  'name' => $name,
  'method' => $method,
  'amount' => $amount,
  'trxid' => $trx,
  'device_id' => $device_id,
  'status' => 'pending',
  'created_at' => date('c')
];
$tx[] = $new;
api_write('donation_transactions.json', $tx);
api_json(['success'=>true,'message'=>'Submitted successfully','data'=>$new]);
