<?php
require_once __DIR__ . '/../config.php';

function api_json($data, int $code=200): void {
    http_response_code($code);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

function api_read($rel, $default=[]){
    global $DATA_DIR;
    $path = rtrim($DATA_DIR,'/').'/'.ltrim($rel,'/');
    if(!file_exists($path)) return $default;
    $json = file_get_contents($path);
    $data = json_decode($json, true);
    return is_array($data) ? $data : $default;
}

function api_save($rel, $data): bool {
    global $DATA_DIR;
    $path = rtrim($DATA_DIR,'/').'/'.ltrim($rel,'/');
    @mkdir(dirname($path), 0775, true);
    $tmp = $path . '.tmp';
    $json = json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    if(file_put_contents($tmp, $json, LOCK_EX)===false) return false;
    return rename($tmp,$path);
}

function guess_base_url(): string {
    // Use configured BASE_URL if set
    global $BASE_URL;
    if (!empty($BASE_URL)) return rtrim($BASE_URL,'/');

    $https = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off');
    $scheme = $https ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
    $dir = rtrim(str_replace('\\','/', dirname($_SERVER['SCRIPT_NAME'] ?? '/')), '/');

    // api/... => go one level up
    $dir = preg_replace('#/api$#', '', $dir);
    return $scheme.'://'.$host.$dir;
}

function upload_url(string $path): string {
    $base = guess_base_url();
    $path = ltrim($path,'/');
    return $base.'/'.$path;
}
