<?php
require_once __DIR__ . '/../common.php';

// Accept GET/POST
$req = array_merge($_GET, $_POST);
$name = trim($req['name'] ?? '');
$address = trim($req['address'] ?? '');
$blood = trim($req['blood_group'] ?? $req['bloodgroup'] ?? '');
$hospital = trim($req['hospital'] ?? '');
$phone = trim($req['phonenumber'] ?? $req['phone'] ?? '');
$device = trim($req['device_id'] ?? $req['deviceId'] ?? '');

if(!$name || !$blood || !$phone){
    api_json(['status'=>'error','message'=>'name, blood_group and phonenumber required'], 400);
}

$donors = api_read('blood_donors.json', []);

// prevent duplicates by phone
foreach($donors as $d){
    if(($d['phonenumber'] ?? '') === $phone){
        api_json(['status'=>'error','message'=>'This phone number already registered']);
    }
}

$new = [
  'id' => uniqid('donor_', true),
  'name' => $name,
  'address' => $address,
  'blood_group' => $blood,
  'hospital' => $hospital,
  'phonenumber' => $phone,
  'device_id' => $device,
  'status' => 'pending',
  'created_at' => date('c')
];
$donors[] = $new;
api_write('blood_donors.json', $donors);
api_json(['status'=>'success','message'=>'Registration submitted','data'=>$new]);
