<?php
require_once __DIR__ . '/../common.php';

// This endpoint stores user to club_users.json as PENDING
// Supports: multipart file 'image' OR base64 string 'imageBase64'

$list = api_read('club_users.json', []);

$name = trim($_POST['name'] ?? '');
$email = trim($_POST['email'] ?? '');
$phone = trim($_POST['phone'] ?? '');
$dob = trim($_POST['dob'] ?? '');
$address = trim($_POST['address'] ?? '');
$position = trim($_POST['position'] ?? '');

if($name==='' || $phone===''){
    api_json(['status'=>'error','message'=>'name and phone are required'], 400);
}

// Duplicate check (phone)
foreach($list as $u){
    if(($u['phone'] ?? '') === $phone){
        api_json(['status'=>'error','message'=>'User already registered'], 409);
    }
}

$imageRel = '';
@mkdir(__DIR__ . '/../../uploads/club_users', 0775, true);
if(isset($_FILES['image']) && $_FILES['image']['error']===UPLOAD_ERR_OK){
    $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION) ?: 'jpg';
    $fname = 'club_'.time().'_'.rand(1000,9999).'.'.$ext;
    $dest = __DIR__ . '/../../uploads/club_users/'.$fname;
    move_uploaded_file($_FILES['image']['tmp_name'], $dest);
    $imageRel = 'uploads/club_users/'.$fname;
} else if(!empty($_POST['imageBase64'])){
    $raw = $_POST['imageBase64'];
    $raw = preg_replace('#^data:image/\w+;base64,#i','',$raw);
    $bin = base64_decode($raw);
    if($bin){
        $fname = 'club_'.time().'_'.rand(1000,9999).'.jpg';
        $dest = __DIR__ . '/../../uploads/club_users/'.$fname;
        file_put_contents($dest, $bin);
        $imageRel = 'uploads/club_users/'.$fname;
    }
}

$item = [
    'id' => 'club_'.bin2hex(random_bytes(6)),
    'name' => $name,
    'email' => $email,
    'phone' => $phone,
    'dob' => $dob,
    'address' => $address,
    'position' => $position,
    'image' => $imageRel,
    'status' => 'pending',
    'created_at' => date('c')
];
$list[] = $item;
api_write('club_users.json', $list);

api_json(['status'=>'success','message'=>'Registration received','data'=>$item]);
