<?php
require_once __DIR__ . '/../common.php';

$payload = json_decode(file_get_contents('php://input'), true);
if(!$payload) $payload = $_POST;

$deviceId = trim($payload['device_id'] ?? '');
$deviceModel = trim($payload['device_model'] ?? '');
$appVersion = trim($payload['app_version'] ?? '');
$event = trim($payload['event'] ?? 'app_open');

if($deviceId === '') {
    api_json(['status'=>'error','message'=>'device_id required'], 400);
}

$logs = api_read('analytics.json', []);
$logs[] = [
    'id' => uniqid('log_', true),
    'device_id' => $deviceId,
    'device_model' => $deviceModel,
    'app_version' => $appVersion,
    'event' => $event,
    'ip' => $_SERVER['REMOTE_ADDR'] ?? '',
    'created_at' => date('c')
];
api_write('analytics.json', $logs);
api_json(['status'=>'success']);
