<?php
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/sidebar.php';

$items = db_read('urgent_numbers.json', []);
$message = '';

$categories = [
    'doctors' => 'Doctors',
    'police' => 'Police',
    'Somazseba' => 'Somazseba',
    'আইনজীবী' => 'Lawyer',
    'ইমাম-সাহেব' => 'Imam',
    'মেম্বার-চেয়ারম্যান' => 'Member/Chairman',
    'শিক্ষা-প্রতিষ্ঠান' => 'School',
];

function find_index_by_id($items, $id){
    foreach($items as $i => $it){
        if(($it['id'] ?? '') === $id) return $i;
    }
    return -1;
}

$action = $_GET['action'] ?? '';
$id = $_GET['id'] ?? '';

if ($action === 'delete' && $id) {
    $idx = find_index_by_id($items, $id);
    if ($idx >= 0) {
        array_splice($items, $idx, 1);
        db_write('urgent_numbers.json', $items);
        $message = 'Deleted successfully';
    }
    header('Location: urgent_numbers.php?msg='.urlencode($message));
    exit;
}

if ($action === 'toggle' && $id) {
    $idx = find_index_by_id($items, $id);
    if ($idx >= 0) {
        $items[$idx]['status'] = (($items[$idx]['status'] ?? 'unpublished') === 'published') ? 'unpublished' : 'published';
        db_write('urgent_numbers.json', $items);
    }
    header('Location: urgent_numbers.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD']==='POST') {
    $id = trim($_POST['id'] ?? '');
    $data = [
        'id' => $id ?: uniqid('u_'),
        'category' => trim($_POST['category'] ?? 'doctors'),
        'name' => trim($_POST['name'] ?? ''),
        'specialization' => trim($_POST['specialization'] ?? ''),
        'hospital' => trim($_POST['hospital'] ?? ''),
        'area' => trim($_POST['area'] ?? ''),
        'phone' => trim($_POST['phone'] ?? ''),
        'imageUrl' => trim($_POST['imageUrl'] ?? ''),
        'status' => trim($_POST['status'] ?? 'published'),
        'updated_at' => date('c'),
    ];

    if (!$data['name'] || !$data['phone']) {
        $message = 'Name and phone required';
    } else {
        $idx = find_index_by_id($items, $data['id']);
        if ($idx >= 0) {
            $items[$idx] = $data;
            $message = 'Updated successfully';
        } else {
            $items[] = $data;
            $message = 'Added successfully';
        }
        db_write('urgent_numbers.json', $items);
        header('Location: urgent_numbers.php?msg='.urlencode($message));
        exit;
    }
}

$editId = $_GET['edit'] ?? '';
$editItem = null;
if ($editId) {
    $idx = find_index_by_id($items, $editId);
    if ($idx >= 0) $editItem = $items[$idx];
}

$msg = $_GET['msg'] ?? '';
?>
<div class="content-wrapper">
  <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6"><h1>Urgent Numbers (All Categories)</h1></div>
      </div>
    </div>
  </section>

  <section class="content">
    <div class="container-fluid">
      <?php if($msg): ?>
        <div class="alert alert-success">✅ <?php echo htmlspecialchars($msg); ?></div>
      <?php endif; ?>
      <?php if($message): ?>
        <div class="alert alert-danger">❌ <?php echo htmlspecialchars($message); ?></div>
      <?php endif; ?>

      <div class="row">
        <div class="col-lg-4">
          <div class="card card-primary">
            <div class="card-header"><h3 class="card-title"><?php echo $editItem ? 'Edit' : 'Add'; ?> Item</h3></div>
            <form method="post">
              <div class="card-body">
                <input type="hidden" name="id" value="<?php echo htmlspecialchars($editItem['id'] ?? ''); ?>">

                <div class="form-group">
                  <label>Category</label>
                  <select name="category" class="form-control" required>
                    <?php foreach($categories as $k=>$v): ?>
                      <option value="<?php echo htmlspecialchars($k); ?>" <?php echo (($editItem['category'] ?? 'doctors')===$k)?'selected':''; ?>><?php echo htmlspecialchars($v); ?></option>
                    <?php endforeach; ?>
                  </select>
                </div>

                <div class="form-group">
                  <label>Name</label>
                  <input name="name" class="form-control" value="<?php echo htmlspecialchars($editItem['name'] ?? ''); ?>" required>
                </div>

                <div class="form-group">
                  <label>Specialization / Position</label>
                  <input name="specialization" class="form-control" value="<?php echo htmlspecialchars($editItem['specialization'] ?? ''); ?>">
                </div>

                <div class="form-group">
                  <label>Hospital / Office / Mosque / Union</label>
                  <input name="hospital" class="form-control" value="<?php echo htmlspecialchars($editItem['hospital'] ?? ''); ?>">
                </div>

                <div class="form-group">
                  <label>Area / Address</label>
                  <input name="area" class="form-control" value="<?php echo htmlspecialchars($editItem['area'] ?? ''); ?>">
                </div>

                <div class="form-group">
                  <label>Phone</label>
                  <input name="phone" class="form-control" value="<?php echo htmlspecialchars($editItem['phone'] ?? ''); ?>" required>
                </div>

                <div class="form-group">
                  <label>Image URL (optional)</label>
                  <input name="imageUrl" class="form-control" value="<?php echo htmlspecialchars($editItem['imageUrl'] ?? ''); ?>">
                </div>

                <div class="form-group">
                  <label>Status</label>
                  <select name="status" class="form-control">
                    <option value="published" <?php echo (($editItem['status'] ?? 'published')==='published')?'selected':''; ?>>published</option>
                    <option value="unpublished" <?php echo (($editItem['status'] ?? 'published')==='unpublished')?'selected':''; ?>>unpublished</option>
                  </select>
                </div>

              </div>
              <div class="card-footer">
                <button class="btn btn-primary">Save</button>
                <a href="urgent_numbers.php" class="btn btn-secondary">Clear</a>
              </div>
            </form>
          </div>
        </div>

        <div class="col-lg-8">
          <div class="card">
            <div class="card-header"><h3 class="card-title">All Items</h3></div>
            <div class="card-body table-responsive p-0">
              <table class="table table-hover text-nowrap">
                <thead>
                  <tr>
                    <th>Name</th>
                    <th>Category</th>
                    <th>Phone</th>
                    <th>Status</th>
                    <th style="width:220px">Action</th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach(array_reverse($items) as $it): ?>
                    <tr>
                      <td><?php echo htmlspecialchars($it['name'] ?? ''); ?></td>
                      <td><?php echo htmlspecialchars($it['category'] ?? ''); ?></td>
                      <td><?php echo htmlspecialchars($it['phone'] ?? ''); ?></td>
                      <td>
                        <?php if(($it['status'] ?? '')==='published'): ?>
                          <span class="badge badge-success">published</span>
                        <?php else: ?>
                          <span class="badge badge-secondary">unpublished</span>
                        <?php endif; ?>
                      </td>
                      <td>
                        <a class="btn btn-sm btn-info" href="urgent_numbers.php?edit=<?php echo urlencode($it['id']); ?>">Edit</a>
                        <a class="btn btn-sm btn-warning" href="urgent_numbers.php?action=toggle&id=<?php echo urlencode($it['id']); ?>">Toggle</a>
                        <a class="btn btn-sm btn-danger" onclick="return confirm('Delete?')" href="urgent_numbers.php?action=delete&id=<?php echo urlencode($it['id']); ?>">Delete</a>
                      </td>
                    </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          </div>

          <div class="alert alert-info">
            ✅ Android API: <b>/api/urgentnumber/search_api.php?category=doctors&query=</b>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>
<?php require_once __DIR__ . '/includes/footer.php'; ?>
