<?php
require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../includes/sidebar.php';

$slider = db_read('slider.json', ['slider_speed'=>3000,'breaking_news'=>'','images'=>[]]);
$message = '';

// Update settings
if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['update_settings'])) {
    $slider['slider_speed'] = max(1000, (int)($_POST['slider_speed'] ?? 3000));
    $slider['breaking_news'] = trim($_POST['breaking_news'] ?? '');
    db_write('slider.json', $slider);
    $message = '✅ Slider settings updated!';
}

// Upload image
if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['upload_image'])) {
    if (!isset($_FILES['image']) || $_FILES['image']['error']!==UPLOAD_ERR_OK) {
        $message = '❌ Image upload failed!';
    } else {
        $ext = strtolower(pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION));
        $allowed = ['jpg','jpeg','png','webp'];
        if (!in_array($ext, $allowed)) {
            $message = '❌ Only JPG/PNG/WEBP allowed.';
        } else {
            $name = 'slider_'.time().'_'.rand(1000,9999).'.'.$ext;
            $target = __DIR__ . '/../../uploads/slider/'.$name;
            @mkdir(dirname($target), 0775, true);
            move_uploaded_file($_FILES['image']['tmp_name'], $target);
            $slider['images'][] = ['url'=>'uploads/slider/'.$name, 'status'=>'published'];
            db_write('slider.json', $slider);
            $message = '✅ Image added!';
        }
    }
}

// Toggle / delete
$action = $_GET['action'] ?? '';
$idx = isset($_GET['i']) ? (int)$_GET['i'] : -1;
if ($action && $idx>=0 && isset($slider['images'][$idx])) {
    if ($action==='toggle') {
        $slider['images'][$idx]['status'] = ($slider['images'][$idx]['status']==='published') ? 'unpublished' : 'published';
        db_write('slider.json', $slider);
        $message = '✅ Updated status!';
    }
    if ($action==='delete') {
        $img = $slider['images'][$idx]['url'] ?? '';
        if ($img) {
            $path = __DIR__.'/../../'.$img;
            if (file_exists($path)) @unlink($path);
        }
        array_splice($slider['images'], $idx, 1);
        db_write('slider.json', $slider);
        $message = '✅ Image deleted!';
    }
}
?>
<div class="content-wrapper">
  <div class="content-header">
    <div class="container-fluid">
      <div class="d-flex justify-content-between align-items-center">
        <h1 class="m-0">Slider / Breaking News</h1>
        <a class="btn btn-outline-primary" href="../index.php">Back Dashboard</a>
      </div>
    </div>
  </div>

  <div class="content">
    <div class="container-fluid">
      <?php if($message): ?>
        <div class="alert alert-info"><?php echo htmlspecialchars($message); ?></div>
      <?php endif; ?>

      <div class="row">
        <div class="col-md-5">
          <div class="card">
            <div class="card-header"><strong>Settings</strong></div>
            <div class="card-body">
              <form method="POST">
                <input type="hidden" name="update_settings" value="1">
                <div class="form-group">
                  <label>Slider Speed (ms)</label>
                  <input type="number" class="form-control" name="slider_speed" value="<?php echo (int)$slider['slider_speed']; ?>" min="1000">
                </div>
                <div class="form-group">
                  <label>Breaking News</label>
                  <textarea class="form-control" name="breaking_news" rows="4"><?php echo htmlspecialchars($slider['breaking_news']); ?></textarea>
                </div>
                <button class="btn btn-primary">Save</button>
              </form>
            </div>
          </div>

          <div class="card">
            <div class="card-header"><strong>Add Slider Image</strong></div>
            <div class="card-body">
              <form method="POST" enctype="multipart/form-data">
                <input type="hidden" name="upload_image" value="1">
                <div class="form-group">
                  <input type="file" name="image" class="form-control" accept="image/*" required>
                </div>
                <button class="btn btn-success">Upload</button>
              </form>
            </div>
          </div>
        </div>

        <div class="col-md-7">
          <div class="card">
            <div class="card-header"><strong>Images</strong></div>
            <div class="card-body">
              <div class="row">
                <?php foreach(($slider['images']??[]) as $i=>$img): ?>
                  <div class="col-md-6 mb-3">
                    <div class="border rounded p-2">
                      <img src="../<?php echo htmlspecialchars($img['url']); ?>" class="img-fluid rounded" style="height:150px;object-fit:cover;width:100%">
                      <div class="mt-2 d-flex justify-content-between align-items-center">
                        <span class="badge badge-<?php echo ($img['status']==='published')?'success':'secondary'; ?>"><?php echo htmlspecialchars($img['status']); ?></span>
                        <div>
                          <a class="btn btn-sm btn-warning" href="?action=toggle&i=<?php echo $i; ?>">Toggle</a>
                          <a class="btn btn-sm btn-danger" href="?action=delete&i=<?php echo $i; ?>" onclick="return confirm('Delete this image?')">Delete</a>
                        </div>
                      </div>
                    </div>
                  </div>
                <?php endforeach; ?>
              </div>
              <small class="text-muted">Android API URL: <code>/api/slider/api.php</code></small>
            </div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>
