<?php
require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../includes/sidebar.php';

$msg='';
if($_SERVER['REQUEST_METHOD']==='POST'){
    $old=$_POST['old_password']??'';
    $new=$_POST['new_password']??'';
    $new2=$_POST['new_password2']??'';

    if($new!==$new2){
        $msg='New password does not match.';
    } else {
        $admin = db_read('admin_user.json', null);
        if($admin && password_verify($old, $admin['password_hash']??'')){
            $admin['password_hash']=password_hash($new, PASSWORD_DEFAULT);
            db_write('admin_user.json',$admin);
            $msg='Password updated successfully.';
        } else {
            $msg='Old password is incorrect.';
        }
    }
}
?>
<div class="content-wrapper">
  <section class="content-header">
    <div class="container-fluid"><h1>Settings</h1></div>
  </section>
  <section class="content">
    <div class="container-fluid">
      <?php if($msg): ?><div class="alert alert-info"><?php echo htmlspecialchars($msg); ?></div><?php endif; ?>
      <div class="card">
        <div class="card-header"><h3 class="card-title">Change Admin Password</h3></div>
        <div class="card-body">
          <form method="post">
            <div class="form-group"><label>Old Password</label><input class="form-control" type="password" name="old_password" required></div>
            <div class="form-group"><label>New Password</label><input class="form-control" type="password" name="new_password" required></div>
            <div class="form-group"><label>Confirm New Password</label><input class="form-control" type="password" name="new_password2" required></div>
            <button class="btn btn-primary">Update</button>
          </form>
        </div>
      </div>
    </div>
  </section>
</div>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>
