<?php
require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../includes/sidebar.php';

$nird = db_read('policy_nirdeshika.json', ['title'=>'নির্দেশিকা','content'=>'']);
$niyo = db_read('policy_niyomniti.json', ['title'=>'নিয়মনীতি','content'=>'']);

$message='';
if($_SERVER['REQUEST_METHOD']==='POST'){
    if(isset($_POST['save_nird'])){
        $nird['title']=trim($_POST['nird_title']??'');
        $nird['content']=trim($_POST['nird_content']??'');
        db_write('policy_nirdeshika.json', $nird);
        $message='✅ নির্দেশিকা আপডেট হয়েছে';
    }
    if(isset($_POST['save_niyo'])){
        $niyo['title']=trim($_POST['niyo_title']??'');
        $niyo['content']=trim($_POST['niyo_content']??'');
        db_write('policy_niyomniti.json', $niyo);
        $message='✅ নিয়মনীতি আপডেট হয়েছে';
    }
}
?>

<div class="content-wrapper">
  <section class="content-header"><div class="container-fluid"><h1>📃 Policy (নির্দেশিকা / নিয়মনীতি)</h1></div></section>
  <section class="content">
    <div class="container-fluid">
      <?php if($message): ?><div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div><?php endif; ?>

      <div class="row">
        <div class="col-md-6">
          <div class="card">
            <div class="card-header"><h3 class="card-title">নির্দেশিকা</h3></div>
            <div class="card-body">
              <form method="post">
                <div class="form-group">
                  <label>Title</label>
                  <input class="form-control" name="nird_title" value="<?php echo htmlspecialchars($nird['title']); ?>">
                </div>
                <div class="form-group">
                  <label>Content</label>
                  <textarea class="form-control" name="nird_content" rows="10"><?php echo htmlspecialchars($nird['content']); ?></textarea>
                </div>
                <button class="btn btn-primary" name="save_nird">Save</button>
              </form>
            </div>
          </div>
        </div>

        <div class="col-md-6">
          <div class="card">
            <div class="card-header"><h3 class="card-title">নিয়মনীতি</h3></div>
            <div class="card-body">
              <form method="post">
                <div class="form-group">
                  <label>Title</label>
                  <input class="form-control" name="niyo_title" value="<?php echo htmlspecialchars($niyo['title']); ?>">
                </div>
                <div class="form-group">
                  <label>Content</label>
                  <textarea class="form-control" name="niyo_content" rows="10"><?php echo htmlspecialchars($niyo['content']); ?></textarea>
                </div>
                <button class="btn btn-primary" name="save_niyo">Save</button>
              </form>
            </div>
          </div>
        </div>
      </div>

      <div class="alert alert-info">
        ✅ Android App API files:
        <ul class="mb-0">
          <li>/api/Nirdeshika/policy_output.json.php</li>
          <li>/api/Niyomniti/policy_output.json.php</li>
        </ul>
      </div>

    </div>
  </section>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
