<?php
require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../includes/sidebar.php';

$players = db_read('players.json', []);
$message='';

$action = $_GET['action'] ?? '';
$id = $_GET['id'] ?? '';

if ($action==='delete' && $id) {
    $players = array_values(array_filter($players, fn($p)=>($p['id']??'')!==$id));
    db_write('players.json', $players);
    $message='Deleted';
}

if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['add'])) {
    $new = [
        'id' => bin2hex(random_bytes(8)),
        'name' => trim($_POST['name'] ?? ''),
        'position' => trim($_POST['position'] ?? ''),
        'phone' => trim($_POST['phone'] ?? ''),
        'playtype' => trim($_POST['playtype'] ?? ''),
        'status' => $_POST['status'] ?? 'published',
        'image' => ''
    ];

    if (!empty($_FILES['image']['name'])) {
        $ext = strtolower(pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION));
        if (in_array($ext, ['jpg','jpeg','png','webp'])) {
            $fname = 'p_' . time() . '_' . rand(100,999) . '.' . $ext;
            $dest = __DIR__ . '/../../uploads/players/' . $fname;
            move_uploaded_file($_FILES['image']['tmp_name'], $dest);
            $new['image'] = $fname;
        }
    }

    if ($new['name'] !== '' && $new['phone'] !== '') {
        $players[] = $new;
        db_write('players.json', $players);
        $message='Player added';
    } else {
        $message='Name and phone required';
    }
}
?>
<div class="content-wrapper">
  <div class="content-header"><div class="container-fluid"><h1 class="m-0">Players</h1></div></div>
  <section class="content"><div class="container-fluid">

    <?php if($message): ?>
      <div class="alert alert-info"><?php echo htmlspecialchars($message); ?></div>
    <?php endif; ?>

    <div class="card">
      <div class="card-header"><strong>Add New Player</strong></div>
      <div class="card-body">
        <form method="post" enctype="multipart/form-data" class="row">
          <div class="col-md-3"><input class="form-control" name="name" placeholder="Name" required></div>
          <div class="col-md-2"><input class="form-control" name="position" placeholder="Position"></div>
          <div class="col-md-2"><input class="form-control" name="playtype" placeholder="Play Type"></div>
          <div class="col-md-2"><input class="form-control" name="phone" placeholder="Phone" required></div>
          <div class="col-md-2">
            <select class="form-control" name="status">
              <option value="published">published</option>
              <option value="unpublished">unpublished</option>
            </select>
          </div>
          <div class="col-md-3 mt-2"><input type="file" class="form-control" name="image"></div>
          <div class="col-md-3 mt-2"><button class="btn btn-primary" name="add">Add</button></div>
        </form>
      </div>
    </div>

    <div class="card">
      <div class="card-header"><strong>All Players</strong></div>
      <div class="card-body table-responsive">
        <table class="table table-bordered table-striped">
          <thead><tr><th>Image</th><th>Name</th><th>Position</th><th>Play</th><th>Phone</th><th>Status</th><th>Action</th></tr></thead>
          <tbody>
          <?php foreach($players as $p): ?>
            <tr>
              <td>
                <?php if(!empty($p['image'])): ?>
                  <img src="../..//uploads/players/<?php echo htmlspecialchars($p['image']); ?>" style="width:48px;height:48px;border-radius:50%;object-fit:cover">
                <?php else: ?>
                  -
                <?php endif; ?>
              </td>
              <td><?php echo htmlspecialchars($p['name'] ?? ''); ?></td>
              <td><?php echo htmlspecialchars($p['position'] ?? ''); ?></td>
              <td><?php echo htmlspecialchars($p['playtype'] ?? ''); ?></td>
              <td><?php echo htmlspecialchars($p['phone'] ?? ''); ?></td>
              <td><?php echo htmlspecialchars($p['status'] ?? ''); ?></td>
              <td>
                <a class="btn btn-sm btn-danger" href="?action=delete&id=<?php echo urlencode($p['id']); ?>" onclick="return confirm('Delete?')">Delete</a>
              </td>
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>

  </div></section>
</div>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>
