<?php
require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../includes/sidebar.php';

$data = db_read('others.json', ['others'=>[]]);
$list = $data['others'] ?? [];
$message='';
$action=$_GET['action']??'';
$id=$_GET['id']??'';

if($action==='delete' && $id){
    $list=array_values(array_filter($list, fn($x)=>($x['id']??'')!==$id));
    $data['others']=$list;
    db_write('others.json',$data);
    $message='Deleted!';
}

if($_SERVER['REQUEST_METHOD']==='POST'){
    $title=trim($_POST['title']??'');
    $details=trim($_POST['details']??'');
    $status=$_POST['status']??'published';

    if($title===''){ $message='Title required'; }
    else {
        $list[]=[
            'id'=>uniqid('oth_'),
            'title'=>$title,
            'details'=>$details,
            'status'=>$status,
            'created_at'=>date('c')
        ];
        $data['others']=$list;
        db_write('others.json',$data);
        $message='Saved!';
    }
}
?>
<div class="content-wrapper">
  <section class="content-header"><div class="container-fluid"><h1>Others</h1></div></section>
  <section class="content"><div class="container-fluid">

    <?php if($message): ?><div class="alert alert-info"><?php echo htmlspecialchars($message); ?></div><?php endif; ?>

    <div class="card">
      <div class="card-header"><h3 class="card-title">Add New</h3></div>
      <div class="card-body">
        <form method="post">
          <div class="form-row">
            <div class="form-group col-md-4">
              <label>Title</label>
              <input class="form-control" name="title" required>
            </div>
            <div class="form-group col-md-6">
              <label>Details</label>
              <input class="form-control" name="details">
            </div>
            <div class="form-group col-md-2">
              <label>Status</label>
              <select class="form-control" name="status">
                <option value="published">published</option>
                <option value="unpublished">unpublished</option>
              </select>
            </div>
          </div>
          <button class="btn btn-primary">Save</button>
        </form>
      </div>
    </div>

    <div class="card">
      <div class="card-header"><h3 class="card-title">List</h3></div>
      <div class="card-body table-responsive">
        <table class="table table-bordered table-striped">
          <thead><tr><th>Title</th><th>Status</th><th>Action</th></tr></thead>
          <tbody>
            <?php foreach(array_reverse($list) as $it): ?>
              <tr>
                <td><?php echo htmlspecialchars($it['title']??''); ?></td>
                <td><?php echo htmlspecialchars($it['status']??''); ?></td>
                <td>
                  <a class="btn btn-sm btn-danger" href="?action=delete&id=<?php echo urlencode($it['id']); ?>" onclick="return confirm('Delete?')">Delete</a>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>

  </div></section>
</div>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>
