<?php
require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../includes/sidebar.php';

$data = db_read('contact_info.json', [
  'facebook_page' => 'https://facebook.com/yourpage',
  'email' => 'support@example.com',
  'phone' => '',
  'address' => ''
]);
$message='';

if($_SERVER['REQUEST_METHOD']==='POST'){
    $data['facebook_page']=trim($_POST['facebook_page']??'');
    $data['email']=trim($_POST['email']??'');
    $data['phone']=trim($_POST['phone']??'');
    $data['address']=trim($_POST['address']??'');
    db_write('contact_info.json',$data);
    $message='Contact info updated.';
}
?>
<div class="content-wrapper">
  <section class="content-header"><div class="container-fluid"><h1>Contact Info</h1></div></section>
  <section class="content">
    <div class="container-fluid">
      <?php if($message): ?><div class="alert alert-success"><?= htmlspecialchars($message) ?></div><?php endif; ?>
      <div class="card">
        <div class="card-body">
          <form method="post">
            <div class="form-group"><label>Facebook Page</label><input name="facebook_page" class="form-control" value="<?= htmlspecialchars($data['facebook_page']) ?>"></div>
            <div class="form-group"><label>Email</label><input name="email" class="form-control" value="<?= htmlspecialchars($data['email']) ?>"></div>
            <div class="form-group"><label>Phone</label><input name="phone" class="form-control" value="<?= htmlspecialchars($data['phone']) ?>"></div>
            <div class="form-group"><label>Address</label><textarea name="address" class="form-control" rows="2"><?= htmlspecialchars($data['address']) ?></textarea></div>
            <button class="btn btn-primary">Save</button>
          </form>
        </div>
      </div>
    </div>
  </section>
</div>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>
