<?php
require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../includes/sidebar.php';

$ambulances = db_read('ambulance.json', []);
$message='';
$action=$_GET['action']??'';
$id=$_GET['id']??'';

if($action==='delete' && $id){
    $ambulances = array_values(array_filter($ambulances, fn($a)=>($a['id']??'')!==$id));
    db_write('ambulance.json',$ambulances);
    $message='Deleted.';
}

if($_SERVER['REQUEST_METHOD']==='POST'){
    $name=trim($_POST['name']??'');
    $area=trim($_POST['area']??'');
    $phone=trim($_POST['phone']??'');
    $locationurl=trim($_POST['locationurl']??'');
    $status=$_POST['status']??'published';
    if($name && $phone){
        $ambulances[]=[
            'id'=>bin2hex(random_bytes(6)),
            'name'=>$name,
            'area'=>$area,
            'phone'=>$phone,
            'locationurl'=>$locationurl,
            'status'=>$status,
            'created_at'=>date('c')
        ];
        db_write('ambulance.json',$ambulances);
        $message='Saved.';
    }else{
        $message='Name & phone required.';
    }
}
?>
<div class="content-wrapper">
  <section class="content-header"><div class="container-fluid">
    <h1>🚑 Ambulance</h1>
  </div></section>
  <section class="content"><div class="container-fluid">
    <?php if($message):?><div class="alert alert-info"><?php echo htmlspecialchars($message);?></div><?php endif;?>

    <div class="card">
      <div class="card-header"><strong>Add New</strong></div>
      <div class="card-body">
        <form method="post" class="row">
          <div class="col-md-4"><input class="form-control" name="name" placeholder="Name" required></div>
          <div class="col-md-3"><input class="form-control" name="area" placeholder="Area"></div>
          <div class="col-md-3"><input class="form-control" name="phone" placeholder="Phone" required></div>
          <div class="col-md-6 mt-2"><input class="form-control" name="locationurl" placeholder="Google Map URL"></div>
          <div class="col-md-3 mt-2">
            <select class="form-control" name="status">
              <option value="published">published</option>
              <option value="unpublished">unpublished</option>
            </select>
          </div>
          <div class="col-md-3 mt-2"><button class="btn btn-primary">Save</button></div>
        </form>
      </div>
    </div>

    <div class="card">
      <div class="card-header"><strong>All Ambulances</strong></div>
      <div class="card-body table-responsive">
        <table class="table table-bordered table-hover">
          <thead><tr><th>Name</th><th>Area</th><th>Phone</th><th>Status</th><th>Action</th></tr></thead>
          <tbody>
            <?php foreach($ambulances as $a):?>
              <tr>
                <td><?php echo htmlspecialchars($a['name']??'');?></td>
                <td><?php echo htmlspecialchars($a['area']??'');?></td>
                <td><?php echo htmlspecialchars($a['phone']??'');?></td>
                <td><span class="badge badge-<?php echo (($a['status']??'')==='published')?'success':'secondary';?>"><?php echo htmlspecialchars($a['status']??'');?></span></td>
                <td><a class="btn btn-sm btn-danger" href="?action=delete&id=<?php echo urlencode($a['id']);?>" onclick="return confirm('Delete?')">Delete</a></td>
              </tr>
            <?php endforeach;?>
          </tbody>
        </table>
      </div>
    </div>

  </div></section>
</div>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>
