<?php
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/sidebar.php';

$data = db_read('kazi_office.json', ['kazi'=>[]]);
$list = $data['kazi'] ?? [];
$message='';
$action=$_GET['action']??'';
$id=$_GET['id']??'';

if($action==='delete' && $id){
    $list=array_values(array_filter($list, fn($x)=>($x['id']??'')!==$id));
    $data['kazi']=$list;
    db_write('kazi_office.json',$data);
    $message='Deleted.';
}

if($_SERVER['REQUEST_METHOD']==='POST'){
    $name=trim($_POST['name']??'');
    $area=trim($_POST['area']??'');
    $phone=trim($_POST['phone']??'');
    $url=trim($_POST['locationurl']??'');
    $status=$_POST['status']??'published';

    if($name===''||$phone===''){ $message='Name and phone required.'; }
    else{
        $list[]=[
            'id'=>bin2hex(random_bytes(8)),
            'name'=>$name,
            'area'=>$area,
            'phone'=>$phone,
            'locationurl'=>$url,
            'status'=>$status,
            'created_at'=>date('c')
        ];
        $data['kazi']=$list;
        db_write('kazi_office.json',$data);
        $message='Added.';
    }
}
?>
<div class="content-wrapper">
  <section class="content-header"><div class="container-fluid"><h1>Kazi Office</h1></div></section>
  <section class="content">
    <div class="container-fluid">
      <?php if($message): ?><div class="alert alert-info"><?= htmlspecialchars($message) ?></div><?php endif; ?>

      <div class="card">
        <div class="card-header"><h3 class="card-title">Add New</h3></div>
        <div class="card-body">
          <form method="post" class="row">
            <div class="col-md-3"><input name="name" class="form-control" placeholder="Name" required></div>
            <div class="col-md-3"><input name="area" class="form-control" placeholder="Area"></div>
            <div class="col-md-2"><input name="phone" class="form-control" placeholder="Phone" required></div>
            <div class="col-md-2"><input name="locationurl" class="form-control" placeholder="Location URL"></div>
            <div class="col-md-2">
              <select name="status" class="form-control">
                <option value="published">published</option>
                <option value="unpublished">unpublished</option>
              </select>
            </div>
            <div class="col-md-12 mt-2"><button class="btn btn-primary">Save</button></div>
          </form>
        </div>
      </div>

      <div class="card">
        <div class="card-header"><h3 class="card-title">List</h3></div>
        <div class="card-body table-responsive">
          <table class="table table-striped">
            <thead><tr><th>Name</th><th>Area</th><th>Phone</th><th>Status</th><th>Action</th></tr></thead>
            <tbody>
            <?php foreach(array_reverse($list) as $it): ?>
              <tr>
                <td><?= htmlspecialchars($it['name']??'') ?></td>
                <td><?= htmlspecialchars($it['area']??'') ?></td>
                <td><?= htmlspecialchars($it['phone']??'') ?></td>
                <td><span class="badge badge-<?= ($it['status']??'published')==='published'?'success':'secondary' ?>"><?= htmlspecialchars($it['status']??'') ?></span></td>
                <td><a class="btn btn-sm btn-danger" onclick="return confirm('Delete?')" href="?action=delete&id=<?= urlencode($it['id']) ?>">Delete</a></td>
              </tr>
            <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>

    </div>
  </section>
</div>
<?php require_once __DIR__ . '/includes/footer.php'; ?>
