<?php
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/sidebar.php';

$urgent = db_read('urgent_numbers.json', []);
$ambulance = db_read('ambulance.json', []);
$fire = db_read('fire_service.json', ['fire_services'=>[]]);
$others = db_read('others.json', ['others'=>[]]);
$players = db_read('players.json', []);
$blood = db_read('blood_donors.json', []);
$club = db_read('club_users.json', []);
$donTx = db_read('donation_transactions.json', []);
$slider = db_read('slider.json', []);
$analytics = db_read('analytics.json', []);

// counts
$urgentCount = count($urgent);
$ambulanceCount = count($ambulance);
$fireCount = count($fire['fire_services'] ?? []);
$othersCount = count($others['others'] ?? []);
$playersCount = count($players);
$bloodPending = count(array_filter($blood, fn($d)=>($d['status']??'')==='pending'));
$bloodApproved = count(array_filter($blood, fn($d)=>($d['status']??'')==='approved'));
$clubPending = count(array_filter($club, fn($u)=>($u['status']??'')==='pending'));
$clubApproved = count(array_filter($club, fn($u)=>($u['status']??'')==='approved'));
$txCount = count($donTx);
$sliderPublished = count(array_filter($slider['images'] ?? [], fn($i)=>($i['status']??'')==='published'));
$deviceCount = count($analytics['devices'] ?? []);

// chart data: login_count sum per day
$perDay = [];
foreach (($analytics['devices'] ?? []) as $dev) {
    $day = substr($dev['last_login'] ?? '', -10); // dd-MM-yyyy
    if ($day) $perDay[$day] = ($perDay[$day] ?? 0) + intval($dev['login_count'] ?? 0);
}
ksort($perDay);
$chartLabels = array_slice(array_keys($perDay), -10);
$chartValues = array_map(fn($k)=>$perDay[$k], $chartLabels);
?>

<div class="content-wrapper">
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0">Dashboard</h1>
          <p class="text-muted mb-0">All systems summary + analytics</p>
        </div>
      </div>
    </div>
  </div>

  <section class="content">
    <div class="container-fluid">

      <div class="row">
        <div class="col-lg-3 col-6">
          <div class="small-box bg-info">
            <div class="inner"><h3><?= $urgentCount ?></h3><p>Urgent Numbers</p></div>
            <div class="icon"><i class="fas fa-phone"></i></div>
            <a href="modules/urgent_numbers.php" class="small-box-footer">Manage <i class="fas fa-arrow-circle-right"></i></a>
          </div>
        </div>
        <div class="col-lg-3 col-6">
          <div class="small-box bg-success">
            <div class="inner"><h3><?= $bloodApproved ?></h3><p>Blood Donors Approved</p></div>
            <div class="icon"><i class="fas fa-tint"></i></div>
            <a href="modules/blood_donors.php" class="small-box-footer">Manage <i class="fas fa-arrow-circle-right"></i></a>
          </div>
        </div>
        <div class="col-lg-3 col-6">
          <div class="small-box bg-warning">
            <div class="inner"><h3><?= $clubApproved ?></h3><p>Club Users Approved</p></div>
            <div class="icon"><i class="fas fa-users"></i></div>
            <a href="modules/club_users.php" class="small-box-footer">Manage <i class="fas fa-arrow-circle-right"></i></a>
          </div>
        </div>
        <div class="col-lg-3 col-6">
          <div class="small-box bg-danger">
            <div class="inner"><h3><?= $txCount ?></h3><p>Donation Transactions</p></div>
            <div class="icon"><i class="fas fa-donate"></i></div>
            <a href="modules/donation_transactions.php" class="small-box-footer">View <i class="fas fa-arrow-circle-right"></i></a>
          </div>
        </div>
      </div>

      <div class="row">
        <div class="col-md-8">
          <div class="card">
            <div class="card-header">
              <h3 class="card-title">Login Count (last 10 days)</h3>
            </div>
            <div class="card-body">
              <canvas id="chartLogin"></canvas>
            </div>
          </div>
        </div>
        <div class="col-md-4">
          <div class="card">
            <div class="card-header">
              <h3 class="card-title">Quick Stats</h3>
            </div>
            <div class="card-body">
              <ul class="list-group">
                <li class="list-group-item d-flex justify-content-between"><span>Ambulance</span><span class="badge badge-primary badge-pill"><?= $ambulanceCount ?></span></li>
                <li class="list-group-item d-flex justify-content-between"><span>Fire Services</span><span class="badge badge-primary badge-pill"><?= $fireCount ?></span></li>
                <li class="list-group-item d-flex justify-content-between"><span>Others</span><span class="badge badge-primary badge-pill"><?= $othersCount ?></span></li>
                <li class="list-group-item d-flex justify-content-between"><span>Players</span><span class="badge badge-primary badge-pill"><?= $playersCount ?></span></li>
                <li class="list-group-item d-flex justify-content-between"><span>Slider Published</span><span class="badge badge-success badge-pill"><?= $sliderPublished ?></span></li>
                <li class="list-group-item d-flex justify-content-between"><span>Devices</span><span class="badge badge-info badge-pill"><?= $deviceCount ?></span></li>
              </ul>
              <hr>
              <div class="d-flex justify-content-between">
                <div><small class="text-muted">Blood Pending</small><div class="h5 mb-0"><?= $bloodPending ?></div></div>
                <div><small class="text-muted">Club Pending</small><div class="h5 mb-0"><?= $clubPending ?></div></div>
              </div>
            </div>
          </div>
        </div>
      </div>

    </div>
  </section>
</div>

<script>
const ctx = document.getElementById('chartLogin');
new Chart(ctx, {
  type: 'line',
  data: {
    labels: <?= json_encode($chartLabels) ?>,
    datasets: [{
      label: 'Total Login Count',
      data: <?= json_encode($chartValues) ?>,
      tension: 0.3,
      fill: true,
    }]
  },
  options: {
    responsive: true,
    plugins: { legend: { display: true } }
  }
});
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
