<?php
require_once __DIR__ . '/../../config.php';

function db_path(string $rel): string {
    global $DATA_DIR;
    return rtrim($DATA_DIR, '/').'/'.ltrim($rel, '/');
}

function db_read(string $rel, $default = []) {
    $path = db_path($rel);
    if (!file_exists($path)) return $default;
    $json = file_get_contents($path);
    if ($json === false || trim($json) === '') return $default;
    $data = json_decode($json, true);
    return $data === null ? $default : $data;
}

function db_write(string $rel, $data): bool {
    global $JSON_FLAGS;
    $path = db_path($rel);
    @mkdir(dirname($path), 0775, true);

    $tmp = $path . '.tmp';
    $json = json_encode($data, $JSON_FLAGS);
    if ($json === false) return false;

    $fp = fopen($tmp, 'wb');
    if (!$fp) return false;
    if (flock($fp, LOCK_EX)) {
        fwrite($fp, $json);
        fflush($fp);
        flock($fp, LOCK_UN);
    }
    fclose($fp);
    return rename($tmp, $path);
}

function h($s): string {
    return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8');
}

function now_bd(): string {
    return date('Y-m-d H:i:s');
}

function rand_id(string $prefix=''): string {
    return $prefix . bin2hex(random_bytes(8));
}
