<?php
require_once __DIR__ . '/../../config.php';

function db_read_json(string $path, $default = []) {
    if (!file_exists($path)) return $default;
    $raw = @file_get_contents($path);
    if ($raw === false || trim($raw) === '') return $default;
    $data = json_decode($raw, true);
    if (json_last_error() !== JSON_ERROR_NONE) return $default;
    return $data;
}

function db_write_json(string $path, $data): bool {
    global $JSON_FLAGS;
    $dir = dirname($path);
    if (!is_dir($dir)) @mkdir($dir, 0775, true);

    $json = json_encode($data, $JSON_FLAGS);
    if ($json === false) return false;

    $tmp = $path . '.tmp';
    $fp = @fopen($tmp, 'wb');
    if (!$fp) return false;
    if (!flock($fp, LOCK_EX)) { fclose($fp); return false; }
    fwrite($fp, $json);
    fflush($fp);
    flock($fp, LOCK_UN);
    fclose($fp);
    return @rename($tmp, $path);
}

function db_next_id(array $items): int {
    $max = 0;
    foreach ($items as $it) {
        if (isset($it['id']) && is_numeric($it['id'])) $max = max($max, (int)$it['id']);
    }
    return $max + 1;
}

function h($s) { return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
