<?php
require_once __DIR__ . '/jsondb.php';

function ensure_file(string $rel, $defaultData): void {
    $path = db_path($rel);
    if (!file_exists($path)) {
        @mkdir(dirname($path), 0775, true);
        db_write($rel, $defaultData);
    }
}

function seed_defaults(): void {
    // Slider
    ensure_file('slider.json', [
        'slider_speed' => 3000,
        'breaking_news' => 'Welcome to Dingabanga App!',
        'images' => []
    ]);

    // Donation payment settings
    ensure_file('payment.json', [
        'bkash' => ['number' => '01XXXXXXXXX', 'instruction' => 'bKash (Personal)'],
        'nagad' => ['number' => '01XXXXXXXXX', 'instruction' => 'Nagad (Personal)'],
    ]);
    ensure_file('donation_transactions.json', []);

    // Main data
    ensure_file('urgent_numbers.json', []);
    ensure_file('ambulance.json', []);
    ensure_file('fire_service.json', ['fire_services' => []]);
    ensure_file('kazi_office.json', ['kazi' => []]);
    ensure_file('others.json', ['others' => []]);
    ensure_file('players.json', []);

    // Registers
    ensure_file('blood_donors.json', []);
    ensure_file('club_users.json', []);

    // Policies
    ensure_file('policy_nirdeshika.json', ['title' => 'নির্দেশিকা', 'content' => '']);
    ensure_file('policy_niyomniti.json', ['title' => 'নিয়মনীতি', 'content' => '']);

    // Contact
    ensure_file('contact_info.json', [
        'facebook_page' => 'https://facebook.com/',
        'email' => 'support@example.com',
        'phone' => '',
        'address' => ''
    ]);

    // Analytics
    ensure_file('analytics.json', []);
}
