<?php
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/sidebar.php';

$data = db_read('fire_service.json', ['fire_services'=>[]]);
$list = $data['fire_services'] ?? [];
$message='';

$action=$_GET['action']??'';
$id=$_GET['id']??'';

if($action==='delete' && $id){
    $list = array_values(array_filter($list, fn($it)=>($it['id']??'')!==$id));
    $data['fire_services']=$list;
    db_write('fire_service.json',$data);
    $message='Deleted.';
}

if($_SERVER['REQUEST_METHOD']==='POST'){
    $name=trim($_POST['name']??'');
    $address=trim($_POST['address']??'');
    $phone=trim($_POST['phone']??'');
    if($name&&$phone){
        $list[]=[
            'id'=>uniqid('fire_', true),
            'name'=>$name,
            'address'=>$address,
            'phone'=>$phone
        ];
        $data['fire_services']=$list;
        db_write('fire_service.json',$data);
        $message='Added.';
    }
}
?>
<div class="content-wrapper">
  <section class="content-header">
    <div class="container-fluid"><h1>Fire Service</h1></div>
  </section>
  <section class="content">
    <div class="container-fluid">
      <?php if($message): ?><div class="alert alert-info"> <?php echo htmlspecialchars($message); ?> </div><?php endif; ?>
      <div class="card">
        <div class="card-header"><h3 class="card-title">Add Station</h3></div>
        <div class="card-body">
          <form method="post" class="row">
            <div class="col-md-4"><input class="form-control" name="name" placeholder="Name" required></div>
            <div class="col-md-4"><input class="form-control" name="address" placeholder="Address"></div>
            <div class="col-md-4"><input class="form-control" name="phone" placeholder="Phone" required></div>
            <div class="col-md-12 mt-2"><button class="btn btn-primary">Add</button></div>
          </form>
        </div>
      </div>

      <div class="card">
        <div class="card-header"><h3 class="card-title">All Stations</h3></div>
        <div class="card-body table-responsive">
          <table class="table table-bordered table-sm">
            <thead><tr><th>Name</th><th>Address</th><th>Phone</th><th>Action</th></tr></thead>
            <tbody>
              <?php foreach($list as $it): ?>
                <tr>
                  <td><?php echo htmlspecialchars($it['name']??''); ?></td>
                  <td><?php echo htmlspecialchars($it['address']??''); ?></td>
                  <td><?php echo htmlspecialchars($it['phone']??''); ?></td>
                  <td><a class="btn btn-danger btn-sm" onclick="return confirm('Delete?')" href="fire_service.php?action=delete&id=<?php echo urlencode($it['id']); ?>">Delete</a></td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>

    </div>
  </section>
</div>
<?php require_once __DIR__ . '/includes/footer.php'; ?>
