<?php
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/sidebar.php';

$tx = db_read('donation_transactions.json', []);

// delete
if (($_GET['action'] ?? '') === 'delete' && !empty($_GET['id'])) {
    $id = $_GET['id'];
    $tx = array_values(array_filter($tx, fn($t) => ($t['id'] ?? '') !== $id));
    db_write('donation_transactions.json', $tx);
    header('Location: donation_transactions.php');
    exit;
}
?>
<div class="content-wrapper">
  <section class="content-header">
    <div class="container-fluid">
      <h1>Donation Transactions</h1>
    </div>
  </section>
  <section class="content">
    <div class="container-fluid">
      <div class="card">
        <div class="card-body table-responsive">
          <table class="table table-bordered table-striped">
            <thead>
              <tr>
                <th>Date</th>
                <th>Transaction ID</th>
                <th>Message</th>
                <th>Status</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach (array_reverse($tx) as $t): ?>
                <tr>
                  <td><?php echo htmlspecialchars($t['created_at'] ?? ''); ?></td>
                  <td><b><?php echo htmlspecialchars($t['transaction_id'] ?? ''); ?></b></td>
                  <td><?php echo htmlspecialchars($t['message'] ?? ''); ?></td>
                  <td><?php echo htmlspecialchars($t['status'] ?? 'received'); ?></td>
                  <td>
                    <a class="btn btn-sm btn-danger" onclick="return confirm('Delete?')" href="?action=delete&id=<?php echo urlencode($t['id'] ?? ''); ?>">Delete</a>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </section>
</div>
<?php require_once __DIR__ . '/includes/footer.php'; ?>
