<?php
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/sidebar.php';

$pay = db_read('payment.json', [
  'bkash' => ['number'=>'017xxxxxxxx','instruction'=>'bKash (Personal)'],
  'nagad' => ['number'=>'018xxxxxxxx','instruction'=>'Nagad (Personal)']
]);

$message = '';
if ($_SERVER['REQUEST_METHOD']==='POST') {
    $pay['bkash']['number'] = trim($_POST['bkash_number'] ?? '');
    $pay['bkash']['instruction'] = trim($_POST['bkash_ins'] ?? '');
    $pay['nagad']['number'] = trim($_POST['nagad_number'] ?? '');
    $pay['nagad']['instruction'] = trim($_POST['nagad_ins'] ?? '');

    db_write('payment.json', $pay);
    // also generate payment_output.json for app
    $out = ['bkash'=>$pay['bkash'], 'nagad'=>$pay['nagad']];
    file_put_contents(__DIR__ . '/../../api/donation/payment_output.json', json_encode($out, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
    $message = '✅ Payment settings saved.';
}
?>
<div class="wrapper">
  <div class="content-wrapper">
    <section class="content-header">
      <div class="container-fluid">
        <h1>Donation Payment Settings</h1>
      </div>
    </section>
    <section class="content">
      <div class="container-fluid">
        <?php if($message): ?><div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div><?php endif; ?>
        <div class="card">
          <div class="card-body">
            <form method="post">
              <h5 class="mb-3">bKash</h5>
              <div class="form-group"><label>Number</label><input class="form-control" name="bkash_number" value="<?php echo htmlspecialchars($pay['bkash']['number']); ?>"></div>
              <div class="form-group"><label>Instruction</label><input class="form-control" name="bkash_ins" value="<?php echo htmlspecialchars($pay['bkash']['instruction']); ?>"></div>
              <hr>
              <h5 class="mb-3">Nagad</h5>
              <div class="form-group"><label>Number</label><input class="form-control" name="nagad_number" value="<?php echo htmlspecialchars($pay['nagad']['number']); ?>"></div>
              <div class="form-group"><label>Instruction</label><input class="form-control" name="nagad_ins" value="<?php echo htmlspecialchars($pay['nagad']['instruction']); ?>"></div>
              <button class="btn btn-primary">Save</button>
            </form>
          </div>
        </div>
        <div class="alert alert-info">
          App JSON URL: <code>/api/donation/payment_output.json</code>
        </div>
      </div>
    </section>
  </div>
</div>
<?php require_once __DIR__ . '/includes/footer.php'; ?>
