<?php
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/sidebar.php';

$users = db_read('club_users.json', []);
$message = '';

$action = $_GET['action'] ?? '';
$id = $_GET['id'] ?? '';

if ($action === 'approve' && $id) {
    foreach ($users as &$u) if ($u['id'] === $id) $u['status'] = 'approved';
    db_write('club_users.json', $users);
    $message = 'User approved.';
}
if ($action === 'reject' && $id) {
    foreach ($users as &$u) if ($u['id'] === $id) $u['status'] = 'rejected';
    db_write('club_users.json', $users);
    $message = 'User rejected.';
}
if ($action === 'delete' && $id) {
    $users = array_values(array_filter($users, fn($u)=>$u['id'] !== $id));
    db_write('club_users.json', $users);
    $message = 'User deleted.';
}

// Add user (admin)
if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['add_user'])) {
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    $dob = trim($_POST['dob'] ?? '');
    $address = trim($_POST['address'] ?? '');
    $position = trim($_POST['position'] ?? '');

    if ($name && $phone) {
        $image_path = '';
        if (!empty($_FILES['image']['name'])) {
            $allowed = ['image/jpeg','image/png','image/webp'];
            if (in_array($_FILES['image']['type'], $allowed, true)) {
                $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
                $file = 'club_' . time() . '_' . rand(1000,9999) . '.' . $ext;
                $dest = __DIR__ . '/../../uploads/club_users/' . $file;
                if (move_uploaded_file($_FILES['image']['tmp_name'], $dest)) {
                    $image_path = 'uploads/club_users/' . $file;
                }
            }
        }

        $users[] = [
            'id' => 'cu_' . time() . '_' . rand(1000,9999),
            'name' => $name,
            'email' => $email,
            'phone' => $phone,
            'dob' => $dob,
            'address' => $address,
            'position' => $position,
            'image_path' => $image_path,
            'status' => 'approved',
            'created_at' => date('Y-m-d H:i:s')
        ];
        db_write('club_users.json', $users);
        $message = 'User added.';
    } else {
        $message = 'Name and phone required.';
    }
}

// Export approved to API file (for Android app)
$approved = array_values(array_filter($users, fn($u)=>($u['status'] ?? '')==='approved'));
db_write('../api_ClubRegi_users.json', ['users'=>$approved]);

?>
<div class="content-wrapper">
  <section class="content-header">
    <div class="container-fluid">
      <h1>Club Users</h1>
      <?php if($message): ?><div class="alert alert-info"><?php echo htmlspecialchars($message); ?></div><?php endif; ?>
    </div>
  </section>

  <section class="content">
    <div class="container-fluid">
      <div class="card">
        <div class="card-header"><h3 class="card-title">Add Club User (Admin)</h3></div>
        <div class="card-body">
          <form method="post" enctype="multipart/form-data" class="row">
            <div class="col-md-4"><input class="form-control" name="name" placeholder="Name" required></div>
            <div class="col-md-4"><input class="form-control" name="phone" placeholder="Phone" required></div>
            <div class="col-md-4"><input class="form-control" name="email" placeholder="Email"></div>
            <div class="col-md-4 mt-2"><input class="form-control" name="dob" placeholder="DOB (dd-mm-yyyy)"></div>
            <div class="col-md-4 mt-2"><input class="form-control" name="position" placeholder="Position"></div>
            <div class="col-md-4 mt-2"><input type="file" class="form-control" name="image"></div>
            <div class="col-md-12 mt-2"><input class="form-control" name="address" placeholder="Address"></div>
            <div class="col-md-12 mt-3"><button class="btn btn-primary" name="add_user" value="1">Save</button></div>
          </form>
        </div>
      </div>

      <div class="card">
        <div class="card-header"><h3 class="card-title">All Club Users</h3></div>
        <div class="card-body table-responsive">
          <table class="table table-bordered">
            <thead><tr>
              <th>Image</th><th>Name</th><th>Phone</th><th>Email</th><th>DOB</th><th>Address</th><th>Status</th><th>Actions</th>
            </tr></thead>
            <tbody>
              <?php foreach(array_reverse($users) as $u): ?>
                <tr>
                  <td><?php if(!empty($u['image_path'])): ?><img src="../<?php echo htmlspecialchars($u['image_path']); ?>" style="width:40px;height:40px;border-radius:50%;object-fit:cover;"> <?php endif; ?></td>
                  <td><?php echo htmlspecialchars($u['name'] ?? ''); ?></td>
                  <td><?php echo htmlspecialchars($u['phone'] ?? ''); ?></td>
                  <td><?php echo htmlspecialchars($u['email'] ?? ''); ?></td>
                  <td><?php echo htmlspecialchars($u['dob'] ?? ''); ?></td>
                  <td><?php echo htmlspecialchars($u['address'] ?? ''); ?></td>
                  <td><span class="badge badge-<?php echo (($u['status'] ?? '')==='approved')?'success':((($u['status'] ?? '')==='rejected')?'danger':'warning'); ?>"><?php echo htmlspecialchars($u['status'] ?? 'pending'); ?></span></td>
                  <td>
                    <a class="btn btn-sm btn-success" href="?action=approve&id=<?php echo urlencode($u['id']); ?>">Approve</a>
                    <a class="btn btn-sm btn-warning" href="?action=reject&id=<?php echo urlencode($u['id']); ?>">Reject</a>
                    <a class="btn btn-sm btn-danger" onclick="return confirm('Delete?')" href="?action=delete&id=<?php echo urlencode($u['id']); ?>">Delete</a>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>

      <div class="alert alert-secondary">
        Android API output: <code>/api/ClubRegi/users.json</code>
      </div>
    </div>
  </section>
</div>
<?php require_once __DIR__ . '/includes/footer.php'; ?>
