<?php
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/sidebar.php';

$donors = db_read('blood_donors.json', []);
$message = '';

$action = $_GET['action'] ?? '';
$id = $_GET['id'] ?? '';

if ($action === 'approve' && $id) {
    foreach ($donors as &$d) {
        if ($d['id'] === $id) { $d['status'] = 'approved'; }
    }
    db_write('blood_donors.json', $donors);
    $message = '✅ Approved!';
}
if ($action === 'reject' && $id) {
    foreach ($donors as &$d) {
        if ($d['id'] === $id) { $d['status'] = 'rejected'; }
    }
    db_write('blood_donors.json', $donors);
    $message = '⚠️ Rejected!';
}
if ($action === 'delete' && $id) {
    $donors = array_values(array_filter($donors, fn($d) => $d['id'] !== $id));
    db_write('blood_donors.json', $donors);
    $message = '🗑️ Deleted!';
}

if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['add_donor'])) {
    $name = trim($_POST['name'] ?? '');
    $address = trim($_POST['address'] ?? '');
    $blood_group = trim($_POST['blood_group'] ?? '');
    $hospital = trim($_POST['hospital'] ?? '');
    $phonenumber = trim($_POST['phonenumber'] ?? '');

    if ($name && $address && $blood_group && $hospital && $phonenumber) {
        $donors[] = [
            'id' => uniqid('donor_', true),
            'name' => $name,
            'address' => $address,
            'blood_group' => $blood_group,
            'hospital' => $hospital,
            'phonenumber' => $phonenumber,
            'device_id' => 'admin',
            'status' => $_POST['status'] ?? 'approved',
            'created_at' => date('Y-m-d H:i:s')
        ];
        db_write('blood_donors.json', $donors);
        $message = '✅ Donor added!';
    } else {
        $message = '❌ Please fill all fields.';
    }
}

// Stats
$total = count($donors);
$pending = count(array_filter($donors, fn($d)=>($d['status'] ?? '')==='pending'));
$approved = count(array_filter($donors, fn($d)=>($d['status'] ?? '')==='approved'));
$rejected = count(array_filter($donors, fn($d)=>($d['status'] ?? '')==='rejected'));
?>

<div class="content-wrapper">
  <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6"><h1>🩸 Blood Donors</h1></div>
      </div>
    </div>
  </section>

  <section class="content">
    <div class="container-fluid">
      <?php if($message): ?>
        <div class="alert alert-info"><?php echo htmlspecialchars($message); ?></div>
      <?php endif; ?>

      <div class="row">
        <div class="col-md-3"><div class="small-box bg-info"><div class="inner"><h3><?php echo $total; ?></h3><p>Total</p></div></div></div>
        <div class="col-md-3"><div class="small-box bg-warning"><div class="inner"><h3><?php echo $pending; ?></h3><p>Pending</p></div></div></div>
        <div class="col-md-3"><div class="small-box bg-success"><div class="inner"><h3><?php echo $approved; ?></h3><p>Approved</p></div></div></div>
        <div class="col-md-3"><div class="small-box bg-danger"><div class="inner"><h3><?php echo $rejected; ?></h3><p>Rejected</p></div></div></div>
      </div>

      <div class="card">
        <div class="card-header"><h3 class="card-title">Add Donor (Admin)</h3></div>
        <div class="card-body">
          <form method="post" class="row">
            <input type="hidden" name="add_donor" value="1">
            <div class="col-md-3"><input class="form-control" name="name" placeholder="Name" required></div>
            <div class="col-md-3"><input class="form-control" name="address" placeholder="Address" required></div>
            <div class="col-md-2"><input class="form-control" name="blood_group" placeholder="Blood Group" required></div>
            <div class="col-md-2"><input class="form-control" name="hospital" placeholder="Hospital" required></div>
            <div class="col-md-2"><input class="form-control" name="phonenumber" placeholder="Phone" required></div>
            <div class="col-md-2 mt-2">
              <select name="status" class="form-control">
                <option value="approved">approved</option>
                <option value="pending">pending</option>
                <option value="rejected">rejected</option>
              </select>
            </div>
            <div class="col-md-2 mt-2"><button class="btn btn-primary w-100">Save</button></div>
          </form>
        </div>
      </div>

      <div class="card">
        <div class="card-header"><h3 class="card-title">All Donors</h3></div>
        <div class="card-body table-responsive">
          <table class="table table-bordered table-hover">
            <thead>
              <tr>
                <th>Name</th><th>Group</th><th>Hospital</th><th>Address</th><th>Phone</th><th>Device</th><th>Status</th><th>Action</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach(array_reverse($donors) as $d): ?>
                <tr>
                  <td><?php echo htmlspecialchars($d['name'] ?? ''); ?></td>
                  <td><?php echo htmlspecialchars($d['blood_group'] ?? ''); ?></td>
                  <td><?php echo htmlspecialchars($d['hospital'] ?? ''); ?></td>
                  <td><?php echo htmlspecialchars($d['address'] ?? ''); ?></td>
                  <td><?php echo htmlspecialchars($d['phonenumber'] ?? ''); ?></td>
                  <td><small><?php echo htmlspecialchars($d['device_id'] ?? ''); ?></small></td>
                  <td><span class="badge badge-<?php echo ($d['status'] ?? '')==='approved'?'success':(($d['status'] ?? '')==='pending'?'warning':'danger'); ?>"><?php echo htmlspecialchars($d['status'] ?? ''); ?></span></td>
                  <td>
                    <a class="btn btn-sm btn-success" href="?action=approve&id=<?php echo urlencode($d['id']); ?>">Approve</a>
                    <a class="btn btn-sm btn-warning" href="?action=reject&id=<?php echo urlencode($d['id']); ?>">Reject</a>
                    <a class="btn btn-sm btn-danger" onclick="return confirm('Delete?')" href="?action=delete&id=<?php echo urlencode($d['id']); ?>">Delete</a>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>

    </div>
  </section>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
