<?php
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/sidebar.php';

$logs = db_read('analytics.json', []);

// Basic aggregation
$byDevice = [];
foreach($logs as $e){
    $did = $e['device_id'] ?? 'unknown';
    if(!isset($byDevice[$did])) $byDevice[$did] = ['device_id'=>$did,'count'=>0,'last'=>null,'model'=>$e['device_model']??''];
    $byDevice[$did]['count']++;
    $byDevice[$did]['last'] = max($byDevice[$did]['last'] ?? '0000-00-00 00:00', $e['created_at']??'');
}
$devices = array_values($byDevice);
usort($devices, fn($a,$b)=>strcmp($b['last']??'',$a['last']??''));
?>
<div class="content-wrapper">
  <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6"><h1>Analytics</h1></div>
        <div class="col-sm-6 text-right">
          <small class="text-muted">Events stored: <?php echo count($logs); ?></small>
        </div>
      </div>
    </div>
  </section>

  <section class="content">
    <div class="container-fluid">
      <div class="card">
        <div class="card-header"><h3 class="card-title">Devices</h3></div>
        <div class="card-body table-responsive">
          <table class="table table-bordered table-sm">
            <thead>
              <tr>
                <th>Device ID</th>
                <th>Device Model</th>
                <th>Events</th>
                <th>Last Seen</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach($devices as $d): ?>
              <tr>
                <td><code><?php echo htmlspecialchars($d['device_id']); ?></code></td>
                <td><?php echo htmlspecialchars($d['model'] ?? ''); ?></td>
                <td><?php echo (int)$d['count']; ?></td>
                <td><?php echo htmlspecialchars($d['last'] ?? ''); ?></td>
              </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </section>
</div>
<?php require_once __DIR__ . '/includes/footer.php'; ?>
