<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

$sliderFile = __DIR__ . '/../storage/slider.json';

if (!file_exists($sliderFile)) {
  http_response_code(500);
  echo json_encode(["error" => "slider.json missing"]);
  exit;
}

$data = json_decode(file_get_contents($sliderFile), true);
if (!is_array($data)) $data = [];

$slider_speed  = isset($data["slider_speed"]) ? (int)$data["slider_speed"] : 3000;
$breaking_news = isset($data["breaking_news"]) ? (string)$data["breaking_news"] : "";
$images        = isset($data["images"]) && is_array($data["images"]) ? $data["images"] : [];

$out = [
  "slider_speed" => $slider_speed,
  "breaking_news" => $breaking_news,
  "images" => []
];

foreach ($images as $img) {
  if (!is_array($img)) continue;
  $out["images"][] = [
    "url" => $img["url"] ?? "",
    "status" => $img["status"] ?? "unpublished"
  ];
}

echo json_encode($out, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
