<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type');
header('Access-Control-Allow-Methods: POST, OPTIONS');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
  http_response_code(200);
  exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  echo json_encode(["success"=>false, "message"=>"POST only"]);
  exit;
}

$raw = file_get_contents('php://input');
$payload = json_decode($raw, true);
if (!is_array($payload)) $payload = [];

$device_id    = trim((string)($payload["device_id"] ?? ""));
$device_model = trim((string)($payload["device_model"] ?? ""));
$device_os    = trim((string)($payload["device_os"] ?? ""));
$app_version  = trim((string)($payload["app_version"] ?? ""));
$login_count  = (int)($payload["login_count"] ?? 0);
$last_login   = trim((string)($payload["last_login"] ?? ""));

if ($device_id === "") {
  http_response_code(400);
  echo json_encode(["success"=>false, "message"=>"device_id required"]);
  exit;
}

$dbFile = __DIR__ . '/../storage/users.json';
if (!file_exists($dbFile)) {
  file_put_contents($dbFile, json_encode(["users"=>[]], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

$fp = fopen($dbFile, 'c+');
if (!$fp) {
  http_response_code(500);
  echo json_encode(["success"=>false, "message"=>"cannot open users.json"]);
  exit;
}

flock($fp, LOCK_EX);
$contents = stream_get_contents($fp);
$data = json_decode($contents, true);
if (!is_array($data)) $data = ["users"=>[]];
if (!isset($data["users"]) || !is_array($data["users"])) $data["users"] = [];

$found = false;
for ($i=0; $i<count($data["users"]); $i++) {
  if (($data["users"][$i]["device_id"] ?? "") === $device_id) {
    $found = true;
    $data["users"][$i]["device_model"] = $device_model ?: ($data["users"][$i]["device_model"] ?? "");
    $data["users"][$i]["device_os"]    = $device_os ?: ($data["users"][$i]["device_os"] ?? "");
    $data["users"][$i]["app_version"]  = $app_version ?: ($data["users"][$i]["app_version"] ?? "");
    $data["users"][$i]["login_count"]  = max($login_count, (int)($data["users"][$i]["login_count"] ?? 0));
    $data["users"][$i]["last_login"]   = $last_login ?: date('c');
    $data["users"][$i]["updated_at"]   = date('c');
    break;
  }
}

if (!$found) {
  $data["users"][] = [
    "device_id" => $device_id,
    "device_model" => $device_model,
    "device_os" => $device_os,
    "app_version" => $app_version,
    "login_count" => $login_count,
    "last_login" => $last_login ?: date('c'),
    "created_at" => date('c'),
    "updated_at" => date('c')
  ];
}

rewind($fp);
ftruncate($fp, 0);
fwrite($fp, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));
fflush($fp);
flock($fp, LOCK_UN);
fclose($fp);

echo json_encode(["success"=>true, "message"=>"saved"]);
