<?php
require_once __DIR__ . "/includes/header.php";
require_once __DIR__ . "/includes/config.php";
require_once __DIR__ . "/includes/jsondb.php";

$users = db_read_json($USERS_FILE, ["users"=>[]]);
$list = $users["users"] ?? [];

usort($list, function($a,$b){
  return strcmp(($b["updated_at"] ?? ""), ($a["updated_at"] ?? ""));
});
?>
<div class="card p-3">
  <div class="d-flex justify-content-between align-items-center flex-wrap gap-2">
    <div>
      <div class="fw-semibold fs-5">App Users</div>
      <div class="text-muted small">Collected from Android <code>collect_user_data.php</code></div>
    </div>
  </div>
  <hr>

  <?php if(count($list)===0): ?>
    <div class="text-muted">No users collected yet.</div>
  <?php else: ?>
    <div class="table-responsive">
      <table class="table align-middle">
        <thead>
          <tr>
            <th>Device ID</th>
            <th>Model</th>
            <th>OS</th>
            <th>App Version</th>
            <th>Login Count</th>
            <th>Last Login</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($list as $u): ?>
            <tr>
              <td><code><?= htmlspecialchars($u["device_id"] ?? "") ?></code></td>
              <td><?= htmlspecialchars($u["device_model"] ?? "") ?></td>
              <td><?= htmlspecialchars($u["device_os"] ?? "") ?></td>
              <td><span class="badge text-bg-dark"><?= htmlspecialchars($u["app_version"] ?? "") ?></span></td>
              <td><?= (int)($u["login_count"] ?? 0) ?></td>
              <td><?= htmlspecialchars($u["last_login"] ?? "") ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  <?php endif; ?>
</div>

<?php require_once __DIR__ . "/includes/footer.php"; ?>
