<?php
require_once __DIR__ . "/includes/header.php";
require_once __DIR__ . "/includes/config.php";
require_once __DIR__ . "/includes/jsondb.php";

$slider = db_read_json($SLIDER_FILE, ["slider_speed"=>3000,"breaking_news"=>"","images"=>[]]);
if (!isset($slider["images"]) || !is_array($slider["images"])) $slider["images"] = [];

function save_slider($slider) {
  global $SLIDER_FILE;
  db_write_json($SLIDER_FILE, $slider);
}

if (isset($_GET["toggle"])) {
  $id = $_GET["toggle"];
  foreach ($slider["images"] as &$img) {
    if (($img["id"] ?? "") === $id) {
      $img["status"] = (($img["status"] ?? "unpublished") === "published") ? "unpublished" : "published";
      $img["updated_at"] = date('c');
      save_slider($slider);
      flash_set("success", "Image status updated ✅");
      header("Location: slider.php"); exit;
    }
  }
}

if (isset($_GET["delete"])) {
  $id = $_GET["delete"];
  $new = [];
  foreach ($slider["images"] as $img) {
    if (($img["id"] ?? "") === $id) {
      $path = __DIR__ . "/../" . ($img["url"] ?? "");
      if (is_file($path)) @unlink($path);
      continue;
    }
    $new[] = $img;
  }
  $slider["images"] = $new;
  save_slider($slider);
  flash_set("success", "Image deleted ✅");
  header("Location: slider.php"); exit;
}

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_FILES["image"])) {
  $file = $_FILES["image"];
  if (($file["error"] ?? 1) === 0) {
    $ext = strtolower(pathinfo($file["name"], PATHINFO_EXTENSION));
    $allowed = ["jpg","jpeg","png","webp"];
    if (!in_array($ext, $allowed)) {
      flash_set("danger", "Only JPG/PNG/WEBP allowed!");
      header("Location: slider.php"); exit;
    }

    $name = "slider_" . date("Ymd_His") . "_" . bin2hex(random_bytes(4)) . "." . $ext;
    $dest = __DIR__ . "/../uploads/slider/" . $name;

    if (!is_dir(dirname($dest))) @mkdir(dirname($dest), 0777, true);

    if (move_uploaded_file($file["tmp_name"], $dest)) {
      $slider["images"][] = [
        "id" => bin2hex(random_bytes(8)),
        "url" => "uploads/slider/" . $name,
        "status" => "published",
        "created_at" => date('c'),
        "updated_at" => date('c')
      ];
      save_slider($slider);
      flash_set("success", "Image uploaded ✅ (Published)");
      header("Location: slider.php"); exit;
    } else {
      flash_set("danger", "Upload failed! Folder permission problem.");
      header("Location: slider.php"); exit;
    }
  } else {
    flash_set("danger", "No file selected!");
    header("Location: slider.php"); exit;
  }
}
?>
<div class="row g-3">
  <div class="col-12 col-lg-4">
    <div class="card p-3">
      <div class="fw-semibold fs-5">Upload Slider Image</div>
      <div class="text-muted small">Auto publish after upload.</div>
      <hr>
      <form method="post" enctype="multipart/form-data">
        <input class="form-control" type="file" name="image" accept="image/*" required>
        <button class="btn btn-dark mt-3 w-100"><i class="bi bi-upload"></i> Upload</button>
      </form>
      <div class="mt-3 small text-muted">
        Allowed: JPG / PNG / WEBP <br>
        Folder: <code>uploads/slider/</code>
      </div>
    </div>
  </div>

  <div class="col-12 col-lg-8">
    <div class="card p-3">
      <div class="d-flex justify-content-between align-items-center">
        <div>
          <div class="fw-semibold fs-5">Slider Images</div>
          <div class="text-muted small">Only <b>published</b> images show in the Android app.</div>
        </div>
        <a class="btn btn-outline-dark" href="../api/slider_api.php" target="_blank">
          <i class="bi bi-link-45deg"></i> API Preview
        </a>
      </div>
      <hr>

      <?php if (count($slider["images"]) === 0): ?>
        <div class="text-muted">No images uploaded yet.</div>
      <?php else: ?>
        <div class="table-responsive">
          <table class="table align-middle">
            <thead>
              <tr>
                <th>Preview</th>
                <th>File</th>
                <th>Status</th>
                <th class="text-end">Action</th>
              </tr>
            </thead>
            <tbody>
            <?php foreach ($slider["images"] as $img): 
              $url = "../" . ($img["url"] ?? "");
              $status = $img["status"] ?? "unpublished";
            ?>
              <tr>
                <td style="width:120px">
                  <img src="<?= htmlspecialchars($url) ?>" style="height:54px;width:96px;object-fit:cover;border-radius:12px" onerror="this.style.display='none'">
                </td>
                <td><code><?= htmlspecialchars($img["url"] ?? "") ?></code></td>
                <td>
                  <?php if($status==="published"): ?>
                    <span class="badge text-bg-success">published</span>
                  <?php else: ?>
                    <span class="badge text-bg-secondary">unpublished</span>
                  <?php endif; ?>
                </td>
                <td class="text-end">
                  <a class="btn btn-sm btn-outline-dark" href="?toggle=<?= urlencode($img["id"] ?? "") ?>">
                    <i class="bi bi-arrow-repeat"></i> Toggle
                  </a>
                  <a class="btn btn-sm btn-outline-danger" href="?delete=<?= urlencode($img["id"] ?? "") ?>" onclick="return confirm('Delete this image?')">
                    <i class="bi bi-trash"></i>
                  </a>
                </td>
              </tr>
            <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      <?php endif; ?>
    </div>
  </div>
</div>

<?php require_once __DIR__ . "/includes/footer.php"; ?>
